/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.hadoop.mapred;

import java.io.IOException;
import shaded.org.apache.hadoop.classification.InterfaceAudience;
import shaded.org.apache.hadoop.classification.InterfaceStability;
import shaded.org.apache.hadoop.conf.Configuration;
import shaded.org.apache.hadoop.fs.FileSystem;
import shaded.org.apache.hadoop.fs.Path;
import shaded.org.apache.hadoop.io.MapFile;
import shaded.org.apache.hadoop.io.SequenceFile;
import shaded.org.apache.hadoop.io.Writable;
import shaded.org.apache.hadoop.io.WritableComparable;
import shaded.org.apache.hadoop.io.compress.CompressionCodec;
import shaded.org.apache.hadoop.io.compress.DefaultCodec;
import shaded.org.apache.hadoop.mapred.FileOutputFormat;
import shaded.org.apache.hadoop.mapred.JobConf;
import shaded.org.apache.hadoop.mapred.Partitioner;
import shaded.org.apache.hadoop.mapred.RecordWriter;
import shaded.org.apache.hadoop.mapred.Reporter;
import shaded.org.apache.hadoop.mapred.SequenceFileOutputFormat;
import shaded.org.apache.hadoop.util.Progressable;
import shaded.org.apache.hadoop.util.ReflectionUtils;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class MapFileOutputFormat
extends FileOutputFormat<WritableComparable, Writable> {
    @Override
    public RecordWriter<WritableComparable, Writable> getRecordWriter(FileSystem ignored, JobConf job, String name, Progressable progress) throws IOException {
        Path file = FileOutputFormat.getTaskOutputPath(job, name);
        FileSystem fs = file.getFileSystem(job);
        CompressionCodec codec = null;
        SequenceFile.CompressionType compressionType = SequenceFile.CompressionType.NONE;
        if (MapFileOutputFormat.getCompressOutput(job)) {
            compressionType = SequenceFileOutputFormat.getOutputCompressionType(job);
            Class<CompressionCodec> codecClass = MapFileOutputFormat.getOutputCompressorClass(job, DefaultCodec.class);
            codec = ReflectionUtils.newInstance(codecClass, job);
        }
        final MapFile.Writer out = new MapFile.Writer((Configuration)job, fs, file.toString(), job.getOutputKeyClass().asSubclass(WritableComparable.class), job.getOutputValueClass().asSubclass(Writable.class), compressionType, codec, progress);
        return new RecordWriter<WritableComparable, Writable>(){

            @Override
            public void write(WritableComparable key, Writable value) throws IOException {
                out.append(key, value);
            }

            @Override
            public void close(Reporter reporter) throws IOException {
                out.close();
            }
        };
    }

    public static MapFile.Reader[] getReaders(FileSystem ignored, Path dir, Configuration conf) throws IOException {
        return shaded.org.apache.hadoop.mapreduce.lib.output.MapFileOutputFormat.getReaders(dir, conf);
    }

    public static <K extends WritableComparable, V extends Writable> Writable getEntry(MapFile.Reader[] readers, Partitioner<K, V> partitioner, K key, V value) throws IOException {
        int part = partitioner.getPartition(key, value, readers.length);
        return readers[part].get(key, value);
    }
}

