/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.hadoop.mapred;

import java.io.IOException;
import shaded.org.apache.hadoop.classification.InterfaceAudience;
import shaded.org.apache.hadoop.classification.InterfaceStability;
import shaded.org.apache.hadoop.mapred.JobConf;
import shaded.org.apache.hadoop.mapred.MapRunnable;
import shaded.org.apache.hadoop.mapred.Mapper;
import shaded.org.apache.hadoop.mapred.OutputCollector;
import shaded.org.apache.hadoop.mapred.RecordReader;
import shaded.org.apache.hadoop.mapred.Reporter;
import shaded.org.apache.hadoop.mapred.SkipBadRecords;
import shaded.org.apache.hadoop.util.ReflectionUtils;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class MapRunner<K1, V1, K2, V2>
implements MapRunnable<K1, V1, K2, V2> {
    private Mapper<K1, V1, K2, V2> mapper;
    private boolean incrProcCount;

    @Override
    public void configure(JobConf job) {
        this.mapper = ReflectionUtils.newInstance(job.getMapperClass(), job);
        this.incrProcCount = SkipBadRecords.getMapperMaxSkipRecords(job) > 0L && SkipBadRecords.getAutoIncrMapperProcCount(job);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(RecordReader<K1, V1> input, OutputCollector<K2, V2> output, Reporter reporter) throws IOException {
        try {
            K1 key = input.createKey();
            V1 value = input.createValue();
            while (input.next(key, value)) {
                this.mapper.map(key, value, output, reporter);
                if (!this.incrProcCount) continue;
                reporter.incrCounter("SkippingTaskCounters", "MapProcessedRecords", 1L);
            }
        }
        finally {
            this.mapper.close();
        }
    }

    protected Mapper<K1, V1, K2, V2> getMapper() {
        return this.mapper;
    }
}

