/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.hadoop.mapred;

import shaded.org.apache.hadoop.classification.InterfaceAudience;
import shaded.org.apache.hadoop.classification.InterfaceStability;
import shaded.org.apache.hadoop.mapred.CumulativePeriodicStats;
import shaded.org.apache.hadoop.mapred.PeriodicStatsAccumulator;
import shaded.org.apache.hadoop.mapred.StatePeriodicStats;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class ProgressSplitsBlock {
    final PeriodicStatsAccumulator progressWallclockTime;
    final PeriodicStatsAccumulator progressCPUTime;
    final PeriodicStatsAccumulator progressVirtualMemoryKbytes;
    final PeriodicStatsAccumulator progressPhysicalMemoryKbytes;
    static final int[] NULL_ARRAY = new int[0];
    static final int WALLCLOCK_TIME_INDEX = 0;
    static final int CPU_TIME_INDEX = 1;
    static final int VIRTUAL_MEMORY_KBYTES_INDEX = 2;
    static final int PHYSICAL_MEMORY_KBYTES_INDEX = 3;
    static final int DEFAULT_NUMBER_PROGRESS_SPLITS = 12;

    ProgressSplitsBlock(int numberSplits) {
        this.progressWallclockTime = new CumulativePeriodicStats(numberSplits);
        this.progressCPUTime = new CumulativePeriodicStats(numberSplits);
        this.progressVirtualMemoryKbytes = new StatePeriodicStats(numberSplits);
        this.progressPhysicalMemoryKbytes = new StatePeriodicStats(numberSplits);
    }

    int[][] burst() {
        int[][] result = new int[][]{this.progressWallclockTime.getValues(), this.progressCPUTime.getValues(), this.progressVirtualMemoryKbytes.getValues(), this.progressPhysicalMemoryKbytes.getValues()};
        return result;
    }

    public static int[] arrayGet(int[][] burstedBlock, int index) {
        return burstedBlock == null ? NULL_ARRAY : burstedBlock[index];
    }

    public static int[] arrayGetWallclockTime(int[][] burstedBlock) {
        return ProgressSplitsBlock.arrayGet(burstedBlock, 0);
    }

    public static int[] arrayGetCPUTime(int[][] burstedBlock) {
        return ProgressSplitsBlock.arrayGet(burstedBlock, 1);
    }

    public static int[] arrayGetVMemKbytes(int[][] burstedBlock) {
        return ProgressSplitsBlock.arrayGet(burstedBlock, 2);
    }

    public static int[] arrayGetPhysMemKbytes(int[][] burstedBlock) {
        return ProgressSplitsBlock.arrayGet(burstedBlock, 3);
    }
}

