/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.hadoop.mapred;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import shaded.org.apache.hadoop.classification.InterfaceAudience;
import shaded.org.apache.hadoop.conf.Configuration;
import shaded.org.apache.hadoop.fs.FileSystem;
import shaded.org.apache.hadoop.fs.Path;
import shaded.org.apache.hadoop.io.Text;
import shaded.org.apache.hadoop.mapreduce.ClusterMetrics;
import shaded.org.apache.hadoop.mapreduce.JobID;
import shaded.org.apache.hadoop.mapreduce.JobStatus;
import shaded.org.apache.hadoop.mapreduce.QueueAclsInfo;
import shaded.org.apache.hadoop.mapreduce.QueueInfo;
import shaded.org.apache.hadoop.mapreduce.TaskTrackerInfo;
import shaded.org.apache.hadoop.mapreduce.TypeConverter;
import shaded.org.apache.hadoop.mapreduce.v2.util.MRApps;
import shaded.org.apache.hadoop.security.UserGroupInformation;
import shaded.org.apache.hadoop.security.token.Token;
import shaded.org.apache.hadoop.yarn.api.protocolrecords.GetNewReservationResponse;
import shaded.org.apache.hadoop.yarn.api.protocolrecords.ReservationDeleteRequest;
import shaded.org.apache.hadoop.yarn.api.protocolrecords.ReservationDeleteResponse;
import shaded.org.apache.hadoop.yarn.api.protocolrecords.ReservationListRequest;
import shaded.org.apache.hadoop.yarn.api.protocolrecords.ReservationListResponse;
import shaded.org.apache.hadoop.yarn.api.protocolrecords.ReservationSubmissionRequest;
import shaded.org.apache.hadoop.yarn.api.protocolrecords.ReservationSubmissionResponse;
import shaded.org.apache.hadoop.yarn.api.protocolrecords.ReservationUpdateRequest;
import shaded.org.apache.hadoop.yarn.api.protocolrecords.ReservationUpdateResponse;
import shaded.org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import shaded.org.apache.hadoop.yarn.api.records.ApplicationAttemptReport;
import shaded.org.apache.hadoop.yarn.api.records.ApplicationId;
import shaded.org.apache.hadoop.yarn.api.records.ApplicationReport;
import shaded.org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import shaded.org.apache.hadoop.yarn.api.records.ContainerId;
import shaded.org.apache.hadoop.yarn.api.records.ContainerReport;
import shaded.org.apache.hadoop.yarn.api.records.NodeId;
import shaded.org.apache.hadoop.yarn.api.records.NodeLabel;
import shaded.org.apache.hadoop.yarn.api.records.NodeReport;
import shaded.org.apache.hadoop.yarn.api.records.NodeState;
import shaded.org.apache.hadoop.yarn.api.records.Priority;
import shaded.org.apache.hadoop.yarn.api.records.QueueUserACLInfo;
import shaded.org.apache.hadoop.yarn.api.records.ResourceTypeInfo;
import shaded.org.apache.hadoop.yarn.api.records.SignalContainerCommand;
import shaded.org.apache.hadoop.yarn.api.records.YarnApplicationState;
import shaded.org.apache.hadoop.yarn.api.records.YarnClusterMetrics;
import shaded.org.apache.hadoop.yarn.client.ClientRMProxy;
import shaded.org.apache.hadoop.yarn.client.api.YarnClient;
import shaded.org.apache.hadoop.yarn.client.api.YarnClientApplication;
import shaded.org.apache.hadoop.yarn.conf.YarnConfiguration;
import shaded.org.apache.hadoop.yarn.exceptions.YarnException;
import shaded.org.apache.hadoop.yarn.security.AMRMTokenIdentifier;
import shaded.org.apache.hadoop.yarn.util.ConverterUtils;

public class ResourceMgrDelegate
extends YarnClient {
    private static final Log LOG = LogFactory.getLog(ResourceMgrDelegate.class);
    private YarnConfiguration conf;
    private ApplicationSubmissionContext application;
    private ApplicationId applicationId;
    @InterfaceAudience.Private
    @VisibleForTesting
    protected YarnClient client;
    private Text rmDTService;

    public ResourceMgrDelegate(YarnConfiguration conf) {
        super(ResourceMgrDelegate.class.getName());
        this.conf = conf;
        this.client = YarnClient.createYarnClient();
        this.init(conf);
        this.start();
    }

    protected void serviceInit(Configuration conf) throws Exception {
        this.client.init(conf);
        super.serviceInit(conf);
    }

    protected void serviceStart() throws Exception {
        this.client.start();
        super.serviceStart();
    }

    protected void serviceStop() throws Exception {
        this.client.stop();
        super.serviceStop();
    }

    public TaskTrackerInfo[] getActiveTrackers() throws IOException, InterruptedException {
        try {
            return TypeConverter.fromYarnNodes((List)this.client.getNodeReports(new NodeState[]{NodeState.RUNNING}));
        }
        catch (YarnException e) {
            throw new IOException(e);
        }
    }

    public JobStatus[] getAllJobs() throws IOException, InterruptedException {
        try {
            HashSet<String> appTypes = new HashSet<String>(1);
            appTypes.add("MAPREDUCE");
            EnumSet<YarnApplicationState> appStates = EnumSet.noneOf(YarnApplicationState.class);
            return TypeConverter.fromYarnApps((List)this.client.getApplications(appTypes, appStates), (Configuration)this.conf);
        }
        catch (YarnException e) {
            throw new IOException(e);
        }
    }

    public TaskTrackerInfo[] getBlacklistedTrackers() throws IOException, InterruptedException {
        LOG.warn((Object)"getBlacklistedTrackers - Not implemented yet");
        return new TaskTrackerInfo[0];
    }

    public ClusterMetrics getClusterMetrics() throws IOException, InterruptedException {
        try {
            YarnClusterMetrics metrics = this.client.getYarnClusterMetrics();
            ClusterMetrics oldMetrics = new ClusterMetrics(1, 1, 1, 1, 1, 1, metrics.getNumNodeManagers() * 10, metrics.getNumNodeManagers() * 2, 1, metrics.getNumNodeManagers(), 0, 0);
            return oldMetrics;
        }
        catch (YarnException e) {
            throw new IOException(e);
        }
    }

    public Text getRMDelegationTokenService() {
        if (this.rmDTService == null) {
            this.rmDTService = ClientRMProxy.getRMDelegationTokenService((Configuration)this.conf);
        }
        return this.rmDTService;
    }

    public Token getDelegationToken(Text renewer) throws IOException, InterruptedException {
        try {
            return ConverterUtils.convertFromYarn((shaded.org.apache.hadoop.yarn.api.records.Token)this.client.getRMDelegationToken(renewer), (Text)this.getRMDelegationTokenService());
        }
        catch (YarnException e) {
            throw new IOException(e);
        }
    }

    public String getFilesystemName() throws IOException, InterruptedException {
        return FileSystem.get(this.conf).getUri().toString();
    }

    public JobID getNewJobID() throws IOException, InterruptedException {
        try {
            this.application = this.client.createApplication().getApplicationSubmissionContext();
            this.applicationId = this.application.getApplicationId();
            return TypeConverter.fromYarn((ApplicationId)this.applicationId);
        }
        catch (YarnException e) {
            throw new IOException(e);
        }
    }

    public QueueInfo getQueue(String queueName) throws IOException, InterruptedException {
        try {
            shaded.org.apache.hadoop.yarn.api.records.QueueInfo queueInfo = this.client.getQueueInfo(queueName);
            return queueInfo == null ? null : TypeConverter.fromYarn((shaded.org.apache.hadoop.yarn.api.records.QueueInfo)queueInfo, (Configuration)this.conf);
        }
        catch (YarnException e) {
            throw new IOException(e);
        }
    }

    public QueueAclsInfo[] getQueueAclsForCurrentUser() throws IOException, InterruptedException {
        try {
            return TypeConverter.fromYarnQueueUserAclsInfo((List)this.client.getQueueAclsInfo());
        }
        catch (YarnException e) {
            throw new IOException(e);
        }
    }

    public QueueInfo[] getQueues() throws IOException, InterruptedException {
        try {
            return TypeConverter.fromYarnQueueInfo((List)this.client.getAllQueues(), (Configuration)this.conf);
        }
        catch (YarnException e) {
            throw new IOException(e);
        }
    }

    public QueueInfo[] getRootQueues() throws IOException, InterruptedException {
        try {
            return TypeConverter.fromYarnQueueInfo((List)this.client.getRootQueueInfos(), (Configuration)this.conf);
        }
        catch (YarnException e) {
            throw new IOException(e);
        }
    }

    public QueueInfo[] getChildQueues(String parent) throws IOException, InterruptedException {
        try {
            return TypeConverter.fromYarnQueueInfo((List)this.client.getChildQueueInfos(parent), (Configuration)this.conf);
        }
        catch (YarnException e) {
            throw new IOException(e);
        }
    }

    public String getStagingAreaDir() throws IOException, InterruptedException {
        String user = UserGroupInformation.getCurrentUser().getShortUserName();
        Path path = MRApps.getStagingAreaDir((Configuration)this.conf, (String)user);
        LOG.debug((Object)("getStagingAreaDir: dir=" + path));
        return path.toString();
    }

    public String getSystemDir() throws IOException, InterruptedException {
        Path sysDir = new Path("jobSubmitDir");
        return sysDir.toString();
    }

    public long getTaskTrackerExpiryInterval() throws IOException, InterruptedException {
        return 0L;
    }

    public void setJobPriority(JobID arg0, String arg1) throws IOException, InterruptedException {
    }

    public long getProtocolVersion(String arg0, long arg1) throws IOException {
        return 0L;
    }

    public ApplicationId getApplicationId() {
        return this.applicationId;
    }

    public YarnClientApplication createApplication() throws YarnException, IOException {
        return this.client.createApplication();
    }

    public ApplicationId submitApplication(ApplicationSubmissionContext appContext) throws YarnException, IOException {
        return this.client.submitApplication(appContext);
    }

    public void failApplicationAttempt(ApplicationAttemptId attemptId) throws YarnException, IOException {
        this.client.failApplicationAttempt(attemptId);
    }

    public void killApplication(ApplicationId applicationId) throws YarnException, IOException {
        this.client.killApplication(applicationId);
    }

    public ApplicationReport getApplicationReport(ApplicationId appId) throws YarnException, IOException {
        return this.client.getApplicationReport(appId);
    }

    public Token<AMRMTokenIdentifier> getAMRMToken(ApplicationId appId) throws YarnException, IOException {
        throw new UnsupportedOperationException();
    }

    public List<ApplicationReport> getApplications() throws YarnException, IOException {
        return this.client.getApplications();
    }

    public List<ApplicationReport> getApplications(Set<String> applicationTypes) throws YarnException, IOException {
        return this.client.getApplications(applicationTypes);
    }

    public List<ApplicationReport> getApplications(EnumSet<YarnApplicationState> applicationStates) throws YarnException, IOException {
        return this.client.getApplications(applicationStates);
    }

    public List<ApplicationReport> getApplications(Set<String> applicationTypes, EnumSet<YarnApplicationState> applicationStates) throws YarnException, IOException {
        return this.client.getApplications(applicationTypes, applicationStates);
    }

    public List<ApplicationReport> getApplications(Set<String> applicationTypes, EnumSet<YarnApplicationState> applicationStates, Set<String> applicationTags) throws YarnException, IOException {
        return this.client.getApplications(applicationTypes, applicationStates, applicationTags);
    }

    public List<ApplicationReport> getApplications(Set<String> queues, Set<String> users, Set<String> applicationTypes, EnumSet<YarnApplicationState> applicationStates) throws YarnException, IOException {
        return this.client.getApplications(queues, users, applicationTypes, applicationStates);
    }

    public YarnClusterMetrics getYarnClusterMetrics() throws YarnException, IOException {
        return this.client.getYarnClusterMetrics();
    }

    public List<NodeReport> getNodeReports(NodeState ... states) throws YarnException, IOException {
        return this.client.getNodeReports(states);
    }

    public shaded.org.apache.hadoop.yarn.api.records.Token getRMDelegationToken(Text renewer) throws YarnException, IOException {
        return this.client.getRMDelegationToken(renewer);
    }

    public shaded.org.apache.hadoop.yarn.api.records.QueueInfo getQueueInfo(String queueName) throws YarnException, IOException {
        return this.client.getQueueInfo(queueName);
    }

    public List<shaded.org.apache.hadoop.yarn.api.records.QueueInfo> getAllQueues() throws YarnException, IOException {
        return this.client.getAllQueues();
    }

    public List<shaded.org.apache.hadoop.yarn.api.records.QueueInfo> getRootQueueInfos() throws YarnException, IOException {
        return this.client.getRootQueueInfos();
    }

    public List<shaded.org.apache.hadoop.yarn.api.records.QueueInfo> getChildQueueInfos(String parent) throws YarnException, IOException {
        return this.client.getChildQueueInfos(parent);
    }

    public List<QueueUserACLInfo> getQueueAclsInfo() throws YarnException, IOException {
        return this.client.getQueueAclsInfo();
    }

    public ApplicationAttemptReport getApplicationAttemptReport(ApplicationAttemptId appAttemptId) throws YarnException, IOException {
        return this.client.getApplicationAttemptReport(appAttemptId);
    }

    public List<ApplicationAttemptReport> getApplicationAttempts(ApplicationId appId) throws YarnException, IOException {
        return this.client.getApplicationAttempts(appId);
    }

    public ContainerReport getContainerReport(ContainerId containerId) throws YarnException, IOException {
        return this.client.getContainerReport(containerId);
    }

    public List<ContainerReport> getContainers(ApplicationAttemptId applicationAttemptId) throws YarnException, IOException {
        return this.client.getContainers(applicationAttemptId);
    }

    public void moveApplicationAcrossQueues(ApplicationId appId, String queue) throws YarnException, IOException {
        this.client.moveApplicationAcrossQueues(appId, queue);
    }

    public GetNewReservationResponse createReservation() throws YarnException, IOException {
        return this.client.createReservation();
    }

    public ReservationSubmissionResponse submitReservation(ReservationSubmissionRequest request) throws YarnException, IOException {
        return this.client.submitReservation(request);
    }

    public ReservationUpdateResponse updateReservation(ReservationUpdateRequest request) throws YarnException, IOException {
        return this.client.updateReservation(request);
    }

    public ReservationDeleteResponse deleteReservation(ReservationDeleteRequest request) throws YarnException, IOException {
        return this.client.deleteReservation(request);
    }

    public ReservationListResponse listReservations(ReservationListRequest request) throws YarnException, IOException {
        return this.client.listReservations(request);
    }

    public Map<NodeId, Set<String>> getNodeToLabels() throws YarnException, IOException {
        return this.client.getNodeToLabels();
    }

    public Map<String, Set<NodeId>> getLabelsToNodes() throws YarnException, IOException {
        return this.client.getLabelsToNodes();
    }

    public Map<String, Set<NodeId>> getLabelsToNodes(Set<String> labels) throws YarnException, IOException {
        return this.client.getLabelsToNodes(labels);
    }

    public List<NodeLabel> getClusterNodeLabels() throws YarnException, IOException {
        return this.client.getClusterNodeLabels();
    }

    public Priority updateApplicationPriority(ApplicationId applicationId, Priority priority) throws YarnException, IOException {
        return this.client.updateApplicationPriority(applicationId, priority);
    }

    public void signalToContainer(ContainerId containerId, SignalContainerCommand command) throws YarnException, IOException {
        this.client.signalToContainer(containerId, command);
    }

    public void killApplication(ApplicationId appId, String diagnostics) throws YarnException, IOException {
        this.client.killApplication(appId, diagnostics);
    }

    public List<ResourceTypeInfo> getResourceTypeInfo() throws YarnException, IOException {
        return this.client.getResourceTypeInfo();
    }
}

