/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.hadoop.mapred;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import shaded.org.apache.hadoop.conf.Configuration;
import shaded.org.apache.hadoop.ipc.ProtocolSignature;
import shaded.org.apache.hadoop.ipc.RPC;
import shaded.org.apache.hadoop.ipc.Server;
import shaded.org.apache.hadoop.mapred.JVMId;
import shaded.org.apache.hadoop.mapred.JobID;
import shaded.org.apache.hadoop.mapred.JvmContext;
import shaded.org.apache.hadoop.mapred.JvmTask;
import shaded.org.apache.hadoop.mapred.MapTaskCompletionEventsUpdate;
import shaded.org.apache.hadoop.mapred.SortedRanges;
import shaded.org.apache.hadoop.mapred.Task;
import shaded.org.apache.hadoop.mapred.TaskAttemptID;
import shaded.org.apache.hadoop.mapred.TaskCompletionEvent;
import shaded.org.apache.hadoop.mapred.TaskStatus;
import shaded.org.apache.hadoop.mapred.TaskUmbilicalProtocol;
import shaded.org.apache.hadoop.mapred.WrappedJvmID;
import shaded.org.apache.hadoop.mapreduce.Counters;
import shaded.org.apache.hadoop.mapreduce.TypeConverter;
import shaded.org.apache.hadoop.mapreduce.security.token.JobTokenSecretManager;
import shaded.org.apache.hadoop.mapreduce.util.MRJobConfUtil;
import shaded.org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptId;
import shaded.org.apache.hadoop.mapreduce.v2.app.AppContext;
import shaded.org.apache.hadoop.mapreduce.v2.app.TaskAttemptListener;
import shaded.org.apache.hadoop.mapreduce.v2.app.TaskHeartbeatHandler;
import shaded.org.apache.hadoop.mapreduce.v2.app.job.Job;
import shaded.org.apache.hadoop.mapreduce.v2.app.job.event.TaskAttemptDiagnosticsUpdateEvent;
import shaded.org.apache.hadoop.mapreduce.v2.app.job.event.TaskAttemptEvent;
import shaded.org.apache.hadoop.mapreduce.v2.app.job.event.TaskAttemptEventType;
import shaded.org.apache.hadoop.mapreduce.v2.app.job.event.TaskAttemptStatusUpdateEvent;
import shaded.org.apache.hadoop.mapreduce.v2.app.rm.RMHeartbeatHandler;
import shaded.org.apache.hadoop.mapreduce.v2.app.security.authorize.MRAMPolicyProvider;
import shaded.org.apache.hadoop.net.NetUtils;
import shaded.org.apache.hadoop.security.authorize.PolicyProvider;
import shaded.org.apache.hadoop.service.CompositeService;
import shaded.org.apache.hadoop.util.StringInterner;
import shaded.org.apache.hadoop.util.Time;
import shaded.org.apache.hadoop.yarn.event.Event;
import shaded.org.apache.hadoop.yarn.exceptions.YarnRuntimeException;

public class TaskAttemptListenerImpl
extends CompositeService
implements TaskUmbilicalProtocol,
TaskAttemptListener {
    private static final JvmTask TASK_FOR_INVALID_JVM = new JvmTask(null, true);
    private static final Log LOG = LogFactory.getLog(TaskAttemptListenerImpl.class);
    private AppContext context;
    private Server server;
    protected TaskHeartbeatHandler taskHeartbeatHandler;
    private RMHeartbeatHandler rmHeartbeatHandler;
    private long commitWindowMs;
    private InetSocketAddress address;
    private ConcurrentMap<WrappedJvmID, Task> jvmIDToActiveAttemptMap = new ConcurrentHashMap<WrappedJvmID, Task>();
    private ConcurrentMap<TaskAttemptId, AtomicReference<TaskAttemptStatusUpdateEvent.TaskAttemptStatus>> attemptIdToStatus = new ConcurrentHashMap<TaskAttemptId, AtomicReference<TaskAttemptStatusUpdateEvent.TaskAttemptStatus>>();
    private ConcurrentHashMap<TaskAttemptID, TaskProgressLogPair> taskAttemptLogProgressStamps = new ConcurrentHashMap();
    private Set<WrappedJvmID> launchedJVMs = Collections.newSetFromMap(new ConcurrentHashMap());
    private JobTokenSecretManager jobTokenSecretManager = null;
    private byte[] encryptedSpillKey;

    public TaskAttemptListenerImpl(AppContext context, JobTokenSecretManager jobTokenSecretManager, RMHeartbeatHandler rmHeartbeatHandler, byte[] secretShuffleKey) {
        super(TaskAttemptListenerImpl.class.getName());
        this.context = context;
        this.jobTokenSecretManager = jobTokenSecretManager;
        this.rmHeartbeatHandler = rmHeartbeatHandler;
        this.encryptedSpillKey = secretShuffleKey;
    }

    @Override
    protected void serviceInit(Configuration conf) throws Exception {
        this.registerHeartbeatHandler(conf);
        this.commitWindowMs = conf.getLong("yarn.app.mapreduce.am.job.committer.commit-window", 10000L);
        MRJobConfUtil.setTaskLogProgressDeltaThresholds(conf);
        super.serviceInit(conf);
    }

    @Override
    protected void serviceStart() throws Exception {
        this.startRpcServer();
        super.serviceStart();
    }

    protected void registerHeartbeatHandler(Configuration conf) {
        this.taskHeartbeatHandler = new TaskHeartbeatHandler(this.context.getEventHandler(), this.context.getClock(), conf.getInt("yarn.app.mapreduce.am.job.task.listener.thread-count", 30));
        this.addService(this.taskHeartbeatHandler);
    }

    protected void startRpcServer() {
        Configuration conf = this.getConfig();
        try {
            this.server = new RPC.Builder(conf).setProtocol(TaskUmbilicalProtocol.class).setInstance(this).setBindAddress("0.0.0.0").setPortRangeConfig("yarn.app.mapreduce.am.job.client.port-range").setNumHandlers(conf.getInt("yarn.app.mapreduce.am.job.task.listener.thread-count", 30)).setVerbose(false).setSecretManager(this.jobTokenSecretManager).build();
            if (conf.getBoolean("hadoop.security.authorization", false)) {
                this.refreshServiceAcls(conf, new MRAMPolicyProvider());
            }
            this.server.start();
            this.address = NetUtils.createSocketAddrForHost(this.context.getNMHostname(), this.server.getListenerAddress().getPort());
        }
        catch (IOException e) {
            throw new YarnRuntimeException(e);
        }
    }

    void refreshServiceAcls(Configuration configuration, PolicyProvider policyProvider) {
        this.server.refreshServiceAcl(configuration, policyProvider);
    }

    @Override
    protected void serviceStop() throws Exception {
        this.stopRpcServer();
        if (this.taskAttemptLogProgressStamps != null) {
            this.taskAttemptLogProgressStamps.clear();
        }
        super.serviceStop();
    }

    protected void stopRpcServer() {
        if (this.server != null) {
            this.server.stop();
        }
    }

    @Override
    public InetSocketAddress getAddress() {
        return this.address;
    }

    @Override
    public boolean canCommit(TaskAttemptID taskAttemptID) throws IOException {
        LOG.info((Object)("Commit go/no-go request from " + taskAttemptID.toString()));
        TaskAttemptId attemptID = TypeConverter.toYarn((TaskAttemptID)taskAttemptID);
        this.taskHeartbeatHandler.progressing(attemptID);
        long now = this.context.getClock().getTime();
        if (now - this.rmHeartbeatHandler.getLastHeartbeatTime() > this.commitWindowMs) {
            return false;
        }
        Job job = this.context.getJob(attemptID.getTaskId().getJobId());
        shaded.org.apache.hadoop.mapreduce.v2.app.job.Task task = job.getTask(attemptID.getTaskId());
        return task.canCommit(attemptID);
    }

    @Override
    public void commitPending(TaskAttemptID taskAttemptID, TaskStatus taskStatsu) throws IOException, InterruptedException {
        LOG.info((Object)("Commit-pending state update from " + taskAttemptID.toString()));
        TaskAttemptId attemptID = TypeConverter.toYarn((TaskAttemptID)taskAttemptID);
        this.taskHeartbeatHandler.progressing(attemptID);
        this.context.getEventHandler().handle((Event)new TaskAttemptEvent(attemptID, TaskAttemptEventType.TA_COMMIT_PENDING));
    }

    @Override
    public void done(TaskAttemptID taskAttemptID) throws IOException {
        LOG.info((Object)("Done acknowledgment from " + taskAttemptID.toString()));
        TaskAttemptId attemptID = TypeConverter.toYarn((TaskAttemptID)taskAttemptID);
        this.taskHeartbeatHandler.progressing(attemptID);
        this.context.getEventHandler().handle((Event)new TaskAttemptEvent(attemptID, TaskAttemptEventType.TA_DONE));
    }

    @Override
    public void fatalError(TaskAttemptID taskAttemptID, String msg) throws IOException {
        LOG.fatal((Object)("Task: " + taskAttemptID + " - exited : " + msg));
        this.reportDiagnosticInfo(taskAttemptID, "Error: " + msg);
        TaskAttemptId attemptID = TypeConverter.toYarn((TaskAttemptID)taskAttemptID);
        this.context.getEventHandler().handle((Event)new TaskAttemptEvent(attemptID, TaskAttemptEventType.TA_FAILMSG));
    }

    @Override
    public void fsError(TaskAttemptID taskAttemptID, String message) throws IOException {
        LOG.fatal((Object)("Task: " + taskAttemptID + " - failed due to FSError: " + message));
        this.reportDiagnosticInfo(taskAttemptID, "FSError: " + message);
        TaskAttemptId attemptID = TypeConverter.toYarn((TaskAttemptID)taskAttemptID);
        this.context.getEventHandler().handle((Event)new TaskAttemptEvent(attemptID, TaskAttemptEventType.TA_FAILMSG));
    }

    @Override
    public void shuffleError(TaskAttemptID taskAttemptID, String message) throws IOException {
    }

    @Override
    public MapTaskCompletionEventsUpdate getMapCompletionEvents(JobID jobIdentifier, int startIndex, int maxEvents, TaskAttemptID taskAttemptID) throws IOException {
        LOG.info((Object)("MapCompletionEvents request from " + taskAttemptID.toString() + ". startIndex " + startIndex + " maxEvents " + maxEvents));
        boolean shouldReset = false;
        TaskAttemptId attemptID = TypeConverter.toYarn((TaskAttemptID)taskAttemptID);
        TaskCompletionEvent[] events = this.context.getJob(attemptID.getTaskId().getJobId()).getMapAttemptCompletionEvents(startIndex, maxEvents);
        this.taskHeartbeatHandler.progressing(attemptID);
        return new MapTaskCompletionEventsUpdate(events, shouldReset);
    }

    @Override
    public boolean ping(TaskAttemptID taskAttemptID) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Ping from " + taskAttemptID.toString()));
        }
        return true;
    }

    @Override
    public void reportDiagnosticInfo(TaskAttemptID taskAttemptID, String diagnosticInfo) throws IOException {
        diagnosticInfo = StringInterner.weakIntern(diagnosticInfo);
        LOG.info((Object)("Diagnostics report from " + taskAttemptID.toString() + ": " + diagnosticInfo));
        TaskAttemptId attemptID = TypeConverter.toYarn((TaskAttemptID)taskAttemptID);
        this.taskHeartbeatHandler.progressing(attemptID);
        this.context.getEventHandler().handle((Event)new TaskAttemptDiagnosticsUpdateEvent(attemptID, diagnosticInfo));
    }

    @Override
    public boolean statusUpdate(TaskAttemptID taskAttemptID, TaskStatus taskStatus) throws IOException, InterruptedException {
        TaskAttemptId yarnAttemptID = TypeConverter.toYarn((TaskAttemptID)taskAttemptID);
        AtomicReference lastStatusRef = (AtomicReference)this.attemptIdToStatus.get(yarnAttemptID);
        if (lastStatusRef == null) {
            if (!this.taskHeartbeatHandler.hasRecentlyUnregistered(yarnAttemptID)) {
                LOG.error((Object)("Status update was called with illegal TaskAttemptId: " + yarnAttemptID));
                return false;
            }
            return true;
        }
        this.taskHeartbeatHandler.progressing(yarnAttemptID);
        TaskAttemptStatusUpdateEvent.TaskAttemptStatus taskAttemptStatus = new TaskAttemptStatusUpdateEvent.TaskAttemptStatus();
        taskAttemptStatus.id = yarnAttemptID;
        taskAttemptStatus.progress = taskStatus.getProgress();
        TaskProgressLogPair logPair = this.taskAttemptLogProgressStamps.get(taskAttemptID);
        if (logPair == null) {
            this.taskAttemptLogProgressStamps.putIfAbsent(taskAttemptID, new TaskProgressLogPair(taskAttemptID));
            logPair = this.taskAttemptLogProgressStamps.get(taskAttemptID);
        }
        logPair.update(taskStatus.getProgress());
        taskAttemptStatus.stateString = taskStatus.getStateString();
        taskAttemptStatus.phase = TypeConverter.toYarn((TaskStatus.Phase)taskStatus.getPhase());
        taskAttemptStatus.counters = new Counters(taskStatus.getCounters());
        if (taskStatus.getIsMap() && taskStatus.getMapFinishTime() != 0L) {
            taskAttemptStatus.mapFinishTime = taskStatus.getMapFinishTime();
        }
        if (!taskStatus.getIsMap() && taskStatus.getShuffleFinishTime() != 0L) {
            taskAttemptStatus.shuffleFinishTime = taskStatus.getShuffleFinishTime();
        }
        if (!taskStatus.getIsMap() && taskStatus.getSortFinishTime() != 0L) {
            taskAttemptStatus.sortFinishTime = taskStatus.getSortFinishTime();
        }
        if (taskStatus.getFetchFailedMaps() != null && taskStatus.getFetchFailedMaps().size() > 0) {
            taskAttemptStatus.fetchFailedMaps = new ArrayList<TaskAttemptId>();
            for (TaskAttemptID failedMapId : taskStatus.getFetchFailedMaps()) {
                taskAttemptStatus.fetchFailedMaps.add(TypeConverter.toYarn((TaskAttemptID)failedMapId));
            }
        }
        this.coalesceStatusUpdate(yarnAttemptID, taskAttemptStatus, lastStatusRef);
        return true;
    }

    @Override
    public long getProtocolVersion(String arg0, long arg1) throws IOException {
        return 19L;
    }

    @Override
    public void reportNextRecordRange(TaskAttemptID taskAttemptID, SortedRanges.Range range) throws IOException {
        throw new IOException("Not yet implemented.");
    }

    @Override
    public JvmTask getTask(JvmContext context) throws IOException {
        JVMId jvmId = context.jvmId;
        LOG.info((Object)("JVM with ID : " + jvmId + " asked for a task"));
        JvmTask jvmTask = null;
        WrappedJvmID wJvmID = new WrappedJvmID(jvmId.getJobId(), jvmId.isMap, jvmId.getId());
        if (!this.jvmIDToActiveAttemptMap.containsKey(wJvmID)) {
            LOG.info((Object)("JVM with ID: " + jvmId + " is invalid and will be killed."));
            jvmTask = TASK_FOR_INVALID_JVM;
        } else if (!this.launchedJVMs.contains(wJvmID)) {
            jvmTask = null;
            LOG.info((Object)("JVM with ID: " + jvmId + " asking for task before AM launch registered. Given null task"));
        } else {
            Task task = (Task)this.jvmIDToActiveAttemptMap.remove(wJvmID);
            this.launchedJVMs.remove(wJvmID);
            LOG.info((Object)("JVM with ID: " + jvmId + " given task: " + task.getTaskID()));
            task.setEncryptedSpillKey(this.encryptedSpillKey);
            jvmTask = new JvmTask(task, false);
        }
        return jvmTask;
    }

    @Override
    public void registerPendingTask(Task task, WrappedJvmID jvmID) {
        this.jvmIDToActiveAttemptMap.put(jvmID, task);
    }

    @Override
    public void registerLaunchedTask(TaskAttemptId attemptID, WrappedJvmID jvmId) {
        this.launchedJVMs.add(jvmId);
        this.taskHeartbeatHandler.register(attemptID);
        this.attemptIdToStatus.put(attemptID, new AtomicReference());
    }

    @Override
    public void unregister(TaskAttemptId attemptID, WrappedJvmID jvmID) {
        this.launchedJVMs.remove(jvmID);
        this.jvmIDToActiveAttemptMap.remove(jvmID);
        this.taskHeartbeatHandler.unregister(attemptID);
        this.attemptIdToStatus.remove(attemptID);
    }

    @Override
    public ProtocolSignature getProtocolSignature(String protocol, long clientVersion, int clientMethodsHash) throws IOException {
        return ProtocolSignature.getProtocolSignature(this, protocol, clientVersion, clientMethodsHash);
    }

    private void coalesceStatusUpdate(TaskAttemptId yarnAttemptID, TaskAttemptStatusUpdateEvent.TaskAttemptStatus taskAttemptStatus, AtomicReference<TaskAttemptStatusUpdateEvent.TaskAttemptStatus> lastStatusRef) {
        boolean asyncUpdatedNeeded;
        List<TaskAttemptId> fetchFailedMaps = taskAttemptStatus.fetchFailedMaps;
        TaskAttemptStatusUpdateEvent.TaskAttemptStatus lastStatus = null;
        boolean done = false;
        while (!done) {
            lastStatus = lastStatusRef.get();
            if (lastStatus != null && lastStatus.fetchFailedMaps != null) {
                if (taskAttemptStatus.fetchFailedMaps == null) {
                    taskAttemptStatus.fetchFailedMaps = lastStatus.fetchFailedMaps;
                } else {
                    taskAttemptStatus.fetchFailedMaps = new ArrayList<TaskAttemptId>(lastStatus.fetchFailedMaps.size() + fetchFailedMaps.size());
                    taskAttemptStatus.fetchFailedMaps.addAll(lastStatus.fetchFailedMaps);
                    taskAttemptStatus.fetchFailedMaps.addAll(fetchFailedMaps);
                }
            }
            if (done = lastStatusRef.compareAndSet(lastStatus, taskAttemptStatus)) continue;
            LOG.info((Object)("TaskAttempt " + yarnAttemptID + ": lastStatusRef changed by another thread, retrying..."));
            taskAttemptStatus.fetchFailedMaps = fetchFailedMaps;
        }
        boolean bl = asyncUpdatedNeeded = lastStatus == null;
        if (asyncUpdatedNeeded) {
            this.context.getEventHandler().handle((Event)new TaskAttemptStatusUpdateEvent(taskAttemptStatus.id, lastStatusRef));
        }
    }

    @VisibleForTesting
    ConcurrentMap<TaskAttemptId, AtomicReference<TaskAttemptStatusUpdateEvent.TaskAttemptStatus>> getAttemptIdToStatus() {
        return this.attemptIdToStatus;
    }

    class TaskProgressLogPair {
        private final TaskAttemptID taskAttemptID;
        private volatile long logTimeStamp;
        private volatile double prevProgress;

        TaskProgressLogPair(TaskAttemptID attemptID) {
            this.taskAttemptID = attemptID;
            this.prevProgress = 0.0;
            this.logTimeStamp = 0L;
        }

        private void resetLog(boolean doLog, float progress, double processedProgress, long timestamp) {
            if (doLog) {
                this.prevProgress = processedProgress;
                this.logTimeStamp = timestamp;
                LOG.info((Object)("Progress of TaskAttempt " + this.taskAttemptID + " is : " + progress));
            } else if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Progress of TaskAttempt " + this.taskAttemptID + " is : " + progress));
            }
        }

        public void update(float progress) {
            boolean result;
            double processedProgress = MRJobConfUtil.convertTaskProgressToFactor(progress);
            double diffProgress = processedProgress - this.prevProgress;
            long currentTime = Time.monotonicNow();
            boolean bl = result = Double.compare(diffProgress, MRJobConfUtil.getTaskProgressMinDeltaThreshold()) >= 0;
            if (!result) {
                boolean bl2 = result = currentTime - this.logTimeStamp >= MRJobConfUtil.getTaskProgressWaitDeltaTimeThreshold();
            }
            if (Float.compare(progress, 1.0f) == 0) {
                result = true;
                TaskAttemptListenerImpl.this.taskAttemptLogProgressStamps.remove(this.taskAttemptID);
            }
            this.resetLog(result, progress, processedProgress, currentTime);
        }
    }
}

