/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.hadoop.mapred.jobcontrol;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import shaded.org.apache.hadoop.classification.InterfaceAudience;
import shaded.org.apache.hadoop.classification.InterfaceStability;
import shaded.org.apache.hadoop.mapred.jobcontrol.Job;
import shaded.org.apache.hadoop.mapreduce.lib.jobcontrol.ControlledJob;
import shaded.org.apache.hadoop.mapreduce.lib.jobcontrol.JobControl;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class JobControl
extends shaded.org.apache.hadoop.mapreduce.lib.jobcontrol.JobControl {
    public JobControl(String groupName) {
        super(groupName);
    }

    static ArrayList<Job> castToJobList(List<ControlledJob> cjobs) {
        ArrayList<Job> ret = new ArrayList<Job>();
        for (ControlledJob job : cjobs) {
            ret.add((Job)job);
        }
        return ret;
    }

    public ArrayList<Job> getWaitingJobs() {
        return JobControl.castToJobList(super.getWaitingJobList());
    }

    public ArrayList<Job> getRunningJobs() {
        return JobControl.castToJobList(super.getRunningJobList());
    }

    public ArrayList<Job> getReadyJobs() {
        return JobControl.castToJobList(super.getReadyJobsList());
    }

    public ArrayList<Job> getSuccessfulJobs() {
        return JobControl.castToJobList(super.getSuccessfulJobList());
    }

    public ArrayList<Job> getFailedJobs() {
        return JobControl.castToJobList(super.getFailedJobList());
    }

    public void addJobs(Collection<Job> jobs) {
        for (Job job : jobs) {
            this.addJob(job);
        }
    }

    public int getState() {
        JobControl.ThreadState state = super.getThreadState();
        if (state == JobControl.ThreadState.RUNNING) {
            return 0;
        }
        if (state == JobControl.ThreadState.SUSPENDED) {
            return 1;
        }
        if (state == JobControl.ThreadState.STOPPED) {
            return 2;
        }
        if (state == JobControl.ThreadState.STOPPING) {
            return 3;
        }
        if (state == JobControl.ThreadState.READY) {
            return 4;
        }
        return -1;
    }
}

