/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.hadoop.mapred.join;

import java.io.IOException;
import java.util.ArrayList;
import java.util.PriorityQueue;
import shaded.org.apache.hadoop.classification.InterfaceAudience;
import shaded.org.apache.hadoop.classification.InterfaceStability;
import shaded.org.apache.hadoop.io.Writable;
import shaded.org.apache.hadoop.io.WritableComparable;
import shaded.org.apache.hadoop.io.WritableComparator;
import shaded.org.apache.hadoop.mapred.JobConf;
import shaded.org.apache.hadoop.mapred.join.ComposableRecordReader;
import shaded.org.apache.hadoop.mapred.join.MultiFilterRecordReader;
import shaded.org.apache.hadoop.mapred.join.TupleWritable;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class OverrideRecordReader<K extends WritableComparable, V extends Writable>
extends MultiFilterRecordReader<K, V> {
    OverrideRecordReader(int id, JobConf conf, int capacity, Class<? extends WritableComparator> cmpcl) throws IOException {
        super(id, conf, capacity, cmpcl);
    }

    @Override
    protected V emit(TupleWritable dst) {
        return (V)dst.iterator().next();
    }

    @Override
    protected void fillJoinCollector(K iterkey) throws IOException {
        PriorityQueue q = this.getRecordReaderQueue();
        if (!q.isEmpty()) {
            ComposableRecordReader t;
            int highpos = -1;
            ArrayList<ComposableRecordReader> list = new ArrayList<ComposableRecordReader>(this.kids.length);
            q.peek().key(iterkey);
            WritableComparator cmp = this.getComparator();
            while (0 == cmp.compare((WritableComparable)q.peek().key(), (WritableComparable)iterkey)) {
                t = q.poll();
                if (-1 == highpos || ((ComposableRecordReader)list.get(highpos)).id() < t.id()) {
                    highpos = list.size();
                }
                list.add(t);
                if (!q.isEmpty()) continue;
                break;
            }
            t = (ComposableRecordReader)list.remove(highpos);
            t.accept(this.jc, iterkey);
            for (ComposableRecordReader rr : list) {
                rr.skip(iterkey);
            }
            list.add(t);
            for (ComposableRecordReader rr : list) {
                if (!rr.hasNext()) continue;
                q.add(rr);
            }
        }
    }
}

