/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.hadoop.mapred.lib;

import java.io.IOException;
import shaded.org.apache.hadoop.classification.InterfaceAudience;
import shaded.org.apache.hadoop.classification.InterfaceStability;
import shaded.org.apache.hadoop.mapred.JobConf;
import shaded.org.apache.hadoop.mapred.Mapper;
import shaded.org.apache.hadoop.mapred.OutputCollector;
import shaded.org.apache.hadoop.mapred.Reporter;
import shaded.org.apache.hadoop.mapred.lib.Chain;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class ChainMapper
implements Mapper {
    private Chain chain = new Chain(true);

    public static <K1, V1, K2, V2> void addMapper(JobConf job, Class<? extends Mapper<K1, V1, K2, V2>> klass, Class<? extends K1> inputKeyClass, Class<? extends V1> inputValueClass, Class<? extends K2> outputKeyClass, Class<? extends V2> outputValueClass, boolean byValue, JobConf mapperConf) {
        job.setMapperClass(ChainMapper.class);
        job.setMapOutputKeyClass(outputKeyClass);
        job.setMapOutputValueClass(outputValueClass);
        Chain.addMapper(true, job, klass, inputKeyClass, inputValueClass, outputKeyClass, outputValueClass, byValue, mapperConf);
    }

    @Override
    public void configure(JobConf job) {
        this.chain.configure(job);
    }

    public void map(Object key, Object value, OutputCollector output, Reporter reporter) throws IOException {
        Mapper mapper = this.chain.getFirstMap();
        if (mapper != null) {
            mapper.map(key, value, this.chain.getMapperCollector(0, output, reporter), reporter);
        }
    }

    @Override
    public void close() throws IOException {
        this.chain.close();
    }
}

