/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.hadoop.mapred.lib;

import java.io.IOException;
import shaded.org.apache.hadoop.classification.InterfaceAudience;
import shaded.org.apache.hadoop.classification.InterfaceStability;
import shaded.org.apache.hadoop.fs.FileSystem;
import shaded.org.apache.hadoop.mapred.JobConf;
import shaded.org.apache.hadoop.mapred.OutputFormat;
import shaded.org.apache.hadoop.mapred.RecordWriter;
import shaded.org.apache.hadoop.mapred.Reporter;
import shaded.org.apache.hadoop.util.Progressable;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class FilterOutputFormat<K, V>
implements OutputFormat<K, V> {
    protected OutputFormat<K, V> baseOut;

    public FilterOutputFormat() {
        this.baseOut = null;
    }

    public FilterOutputFormat(OutputFormat<K, V> out) {
        this.baseOut = out;
    }

    @Override
    public RecordWriter<K, V> getRecordWriter(FileSystem ignored, JobConf job, String name, Progressable progress) throws IOException {
        return this.getBaseOut().getRecordWriter(ignored, job, name, progress);
    }

    @Override
    public void checkOutputSpecs(FileSystem ignored, JobConf job) throws IOException {
        this.getBaseOut().checkOutputSpecs(ignored, job);
    }

    private OutputFormat<K, V> getBaseOut() throws IOException {
        if (this.baseOut == null) {
            throw new IOException("Outputformat not set for FilterOutputFormat");
        }
        return this.baseOut;
    }

    public static class FilterRecordWriter<K, V>
    implements RecordWriter<K, V> {
        protected RecordWriter<K, V> rawWriter = null;

        public FilterRecordWriter() throws IOException {
            this.rawWriter = null;
        }

        public FilterRecordWriter(RecordWriter<K, V> rawWriter) throws IOException {
            this.rawWriter = rawWriter;
        }

        @Override
        public void close(Reporter reporter) throws IOException {
            this.getRawWriter().close(reporter);
        }

        @Override
        public void write(K key, V value) throws IOException {
            this.getRawWriter().write(key, value);
        }

        private RecordWriter<K, V> getRawWriter() throws IOException {
            if (this.rawWriter == null) {
                throw new IOException("Record Writer not set for FilterRecordWriter");
            }
            return this.rawWriter;
        }
    }
}

