/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.hadoop.mapred.lib;

import java.io.IOException;
import shaded.org.apache.hadoop.classification.InterfaceAudience;
import shaded.org.apache.hadoop.classification.InterfaceStability;
import shaded.org.apache.hadoop.fs.FileSystem;
import shaded.org.apache.hadoop.mapred.JobConf;
import shaded.org.apache.hadoop.mapred.OutputFormat;
import shaded.org.apache.hadoop.mapred.RecordWriter;
import shaded.org.apache.hadoop.mapred.Reporter;
import shaded.org.apache.hadoop.mapred.lib.FilterOutputFormat;
import shaded.org.apache.hadoop.util.Progressable;
import shaded.org.apache.hadoop.util.ReflectionUtils;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class LazyOutputFormat<K, V>
extends FilterOutputFormat<K, V> {
    public static void setOutputFormatClass(JobConf job, Class<? extends OutputFormat> theClass) {
        job.setOutputFormat(LazyOutputFormat.class);
        job.setClass("mapreduce.output.lazyoutputformat.outputformat", theClass, OutputFormat.class);
    }

    @Override
    public RecordWriter<K, V> getRecordWriter(FileSystem ignored, JobConf job, String name, Progressable progress) throws IOException {
        if (this.baseOut == null) {
            this.getBaseOutputFormat(job);
        }
        return new LazyRecordWriter(job, this.baseOut, name, progress);
    }

    @Override
    public void checkOutputSpecs(FileSystem ignored, JobConf job) throws IOException {
        if (this.baseOut == null) {
            this.getBaseOutputFormat(job);
        }
        super.checkOutputSpecs(ignored, job);
    }

    private void getBaseOutputFormat(JobConf job) throws IOException {
        this.baseOut = ReflectionUtils.newInstance(job.getClass("mapreduce.output.lazyoutputformat.outputformat", null, OutputFormat.class), job);
        if (this.baseOut == null) {
            throw new IOException("Ouput format not set for LazyOutputFormat");
        }
    }

    private static class LazyRecordWriter<K, V>
    extends FilterOutputFormat.FilterRecordWriter<K, V> {
        final OutputFormat of;
        final String name;
        final Progressable progress;
        final JobConf job;

        public LazyRecordWriter(JobConf job, OutputFormat of, String name, Progressable progress) throws IOException {
            this.of = of;
            this.job = job;
            this.name = name;
            this.progress = progress;
        }

        @Override
        public void close(Reporter reporter) throws IOException {
            if (this.rawWriter != null) {
                this.rawWriter.close(reporter);
            }
        }

        @Override
        public void write(K key, V value) throws IOException {
            if (this.rawWriter == null) {
                this.createRecordWriter();
            }
            super.write(key, value);
        }

        private void createRecordWriter() throws IOException {
            FileSystem fs = FileSystem.get(this.job);
            this.rawWriter = this.of.getRecordWriter(fs, this.job, this.name, this.progress);
        }
    }
}

