/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.hadoop.mapred.lib;

import java.io.IOException;
import java.util.Iterator;
import java.util.TreeMap;
import shaded.org.apache.hadoop.classification.InterfaceAudience;
import shaded.org.apache.hadoop.classification.InterfaceStability;
import shaded.org.apache.hadoop.fs.FileSystem;
import shaded.org.apache.hadoop.fs.Path;
import shaded.org.apache.hadoop.mapred.FileOutputFormat;
import shaded.org.apache.hadoop.mapred.JobConf;
import shaded.org.apache.hadoop.mapred.RecordWriter;
import shaded.org.apache.hadoop.mapred.Reporter;
import shaded.org.apache.hadoop.util.Progressable;

@InterfaceAudience.Public
@InterfaceStability.Stable
public abstract class MultipleOutputFormat<K, V>
extends FileOutputFormat<K, V> {
    @Override
    public RecordWriter<K, V> getRecordWriter(FileSystem fs, JobConf job, String name, Progressable arg3) throws IOException {
        final FileSystem myFS = fs;
        final String myName = this.generateLeafFileName(name);
        final JobConf myJob = job;
        final Progressable myProgressable = arg3;
        return new RecordWriter<K, V>(){
            TreeMap<String, RecordWriter<K, V>> recordWriters = new TreeMap();

            @Override
            public void write(K key, V value) throws IOException {
                String keyBasedPath = MultipleOutputFormat.this.generateFileNameForKeyValue(key, value, myName);
                String finalPath = MultipleOutputFormat.this.getInputFileBasedOutputFileName(myJob, keyBasedPath);
                Object actualKey = MultipleOutputFormat.this.generateActualKey(key, value);
                Object actualValue = MultipleOutputFormat.this.generateActualValue(key, value);
                RecordWriter rw = this.recordWriters.get(finalPath);
                if (rw == null) {
                    rw = MultipleOutputFormat.this.getBaseRecordWriter(myFS, myJob, finalPath, myProgressable);
                    this.recordWriters.put(finalPath, rw);
                }
                rw.write(actualKey, actualValue);
            }

            @Override
            public void close(Reporter reporter) throws IOException {
                Iterator<String> keys = this.recordWriters.keySet().iterator();
                while (keys.hasNext()) {
                    RecordWriter rw = this.recordWriters.get(keys.next());
                    rw.close(reporter);
                }
                this.recordWriters.clear();
            }
        };
    }

    protected String generateLeafFileName(String name) {
        return name;
    }

    protected String generateFileNameForKeyValue(K key, V value, String name) {
        return name;
    }

    protected K generateActualKey(K key, V value) {
        return key;
    }

    protected V generateActualValue(K key, V value) {
        return value;
    }

    protected String getInputFileBasedOutputFileName(JobConf job, String name) {
        String infilepath = job.get("mapreduce.map.input.file");
        if (infilepath == null) {
            return name;
        }
        int numOfTrailingLegsToUse = job.getInt("mapred.outputformat.numOfTrailingLegs", 0);
        if (numOfTrailingLegsToUse <= 0) {
            return name;
        }
        Path infile = new Path(infilepath);
        Path parent = infile.getParent();
        String midName = infile.getName();
        Path outPath = new Path(midName);
        for (int i = 1; i < numOfTrailingLegsToUse && parent != null && (midName = parent.getName()).length() != 0; parent = parent.getParent(), ++i) {
            outPath = new Path(midName, outPath);
        }
        return outPath.toString();
    }

    protected abstract RecordWriter<K, V> getBaseRecordWriter(FileSystem var1, JobConf var2, String var3, Progressable var4) throws IOException;
}

