/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.hadoop.mapred.lib;

import java.io.IOException;
import java.util.ArrayList;
import shaded.org.apache.hadoop.classification.InterfaceAudience;
import shaded.org.apache.hadoop.classification.InterfaceStability;
import shaded.org.apache.hadoop.fs.FileStatus;
import shaded.org.apache.hadoop.fs.Path;
import shaded.org.apache.hadoop.io.LongWritable;
import shaded.org.apache.hadoop.io.Text;
import shaded.org.apache.hadoop.mapred.FileInputFormat;
import shaded.org.apache.hadoop.mapred.FileSplit;
import shaded.org.apache.hadoop.mapred.InputSplit;
import shaded.org.apache.hadoop.mapred.JobConf;
import shaded.org.apache.hadoop.mapred.JobConfigurable;
import shaded.org.apache.hadoop.mapred.LineRecordReader;
import shaded.org.apache.hadoop.mapred.RecordReader;
import shaded.org.apache.hadoop.mapred.Reporter;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class NLineInputFormat
extends FileInputFormat<LongWritable, Text>
implements JobConfigurable {
    private int N = 1;

    @Override
    public RecordReader<LongWritable, Text> getRecordReader(InputSplit genericSplit, JobConf job, Reporter reporter) throws IOException {
        reporter.setStatus(genericSplit.toString());
        return new LineRecordReader(job, (FileSplit)genericSplit);
    }

    @Override
    public InputSplit[] getSplits(JobConf job, int numSplits) throws IOException {
        ArrayList<FileSplit> splits = new ArrayList<FileSplit>();
        for (FileStatus status : this.listStatus(job)) {
            for (shaded.org.apache.hadoop.mapreduce.lib.input.FileSplit split : shaded.org.apache.hadoop.mapreduce.lib.input.NLineInputFormat.getSplitsForFile(status, job, this.N)) {
                splits.add(new FileSplit(split));
            }
        }
        return splits.toArray(new FileSplit[splits.size()]);
    }

    @Override
    public void configure(JobConf conf) {
        this.N = conf.getInt("mapreduce.input.lineinputformat.linespermap", 1);
    }

    protected static FileSplit createFileSplit(Path fileName, long begin, long length) {
        return begin == 0L ? new FileSplit(fileName, begin, length - 1L, new String[0]) : new FileSplit(fileName, begin - 1L, length, new String[0]);
    }
}

