/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.hadoop.mapred.lib;

import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import shaded.org.apache.hadoop.classification.InterfaceAudience;
import shaded.org.apache.hadoop.classification.InterfaceStability;
import shaded.org.apache.hadoop.io.LongWritable;
import shaded.org.apache.hadoop.io.Text;
import shaded.org.apache.hadoop.mapred.JobConf;
import shaded.org.apache.hadoop.mapred.MapReduceBase;
import shaded.org.apache.hadoop.mapred.Mapper;
import shaded.org.apache.hadoop.mapred.OutputCollector;
import shaded.org.apache.hadoop.mapred.Reporter;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class RegexMapper<K>
extends MapReduceBase
implements Mapper<K, Text, Text, LongWritable> {
    private Pattern pattern;
    private int group;

    @Override
    public void configure(JobConf job) {
        this.pattern = Pattern.compile(job.get(shaded.org.apache.hadoop.mapreduce.lib.map.RegexMapper.PATTERN));
        this.group = job.getInt(shaded.org.apache.hadoop.mapreduce.lib.map.RegexMapper.GROUP, 0);
    }

    @Override
    public void map(K key, Text value, OutputCollector<Text, LongWritable> output, Reporter reporter) throws IOException {
        String text = value.toString();
        Matcher matcher = this.pattern.matcher(text);
        while (matcher.find()) {
            output.collect(new Text(matcher.group(this.group)), new LongWritable(1L));
        }
    }
}

