/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.hadoop.mapreduce;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import shaded.org.apache.hadoop.classification.InterfaceAudience;
import shaded.org.apache.hadoop.classification.InterfaceStability;
import shaded.org.apache.hadoop.io.Text;
import shaded.org.apache.hadoop.io.Writable;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class TaskTrackerInfo
implements Writable {
    String name;
    boolean isBlacklisted = false;
    String reasonForBlacklist = "";
    String blacklistReport = "";

    public TaskTrackerInfo() {
    }

    public TaskTrackerInfo(String name) {
        this.name = name;
    }

    public TaskTrackerInfo(String name, String reasonForBlacklist, String report) {
        this.name = name;
        this.isBlacklisted = true;
        this.reasonForBlacklist = reasonForBlacklist;
        this.blacklistReport = report;
    }

    public String getTaskTrackerName() {
        return this.name;
    }

    public boolean isBlacklisted() {
        return this.isBlacklisted;
    }

    public String getReasonForBlacklist() {
        return this.reasonForBlacklist;
    }

    public String getBlacklistReport() {
        return this.blacklistReport;
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        this.name = Text.readString(in);
        this.isBlacklisted = in.readBoolean();
        this.reasonForBlacklist = Text.readString(in);
        this.blacklistReport = Text.readString(in);
    }

    @Override
    public void write(DataOutput out) throws IOException {
        Text.writeString(out, this.name);
        out.writeBoolean(this.isBlacklisted);
        Text.writeString(out, this.reasonForBlacklist);
        Text.writeString(out, this.blacklistReport);
    }
}

