/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.hadoop.mapreduce.jobhistory;

import java.util.Set;
import org.apache.avro.util.Utf8;
import shaded.org.apache.hadoop.classification.InterfaceAudience;
import shaded.org.apache.hadoop.classification.InterfaceStability;
import shaded.org.apache.hadoop.mapreduce.JobID;
import shaded.org.apache.hadoop.mapreduce.jobhistory.EventType;
import shaded.org.apache.hadoop.mapreduce.jobhistory.HistoryEvent;
import shaded.org.apache.hadoop.mapreduce.jobhistory.JobInfoChange;
import shaded.org.apache.hadoop.util.StringUtils;
import shaded.org.apache.hadoop.yarn.api.records.timelineservice.TimelineEvent;
import shaded.org.apache.hadoop.yarn.api.records.timelineservice.TimelineMetric;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class JobInfoChangeEvent
implements HistoryEvent {
    private JobInfoChange datum = new JobInfoChange();

    public JobInfoChangeEvent(JobID id, long submitTime, long launchTime) {
        this.datum.setJobid((CharSequence)new Utf8(id.toString()));
        this.datum.setSubmitTime(submitTime);
        this.datum.setLaunchTime(launchTime);
    }

    JobInfoChangeEvent() {
    }

    @Override
    public Object getDatum() {
        return this.datum;
    }

    @Override
    public void setDatum(Object datum) {
        this.datum = (JobInfoChange)((Object)datum);
    }

    public JobID getJobId() {
        return JobID.forName(this.datum.getJobid().toString());
    }

    public long getSubmitTime() {
        return this.datum.getSubmitTime();
    }

    public long getLaunchTime() {
        return this.datum.getLaunchTime();
    }

    @Override
    public EventType getEventType() {
        return EventType.JOB_INFO_CHANGED;
    }

    @Override
    public TimelineEvent toTimelineEvent() {
        TimelineEvent tEvent = new TimelineEvent();
        tEvent.setId(StringUtils.toUpperCase(this.getEventType().name()));
        tEvent.addInfo("SUBMIT_TIME", this.getSubmitTime());
        tEvent.addInfo("LAUNCH_TIME", this.getLaunchTime());
        return tEvent;
    }

    @Override
    public Set<TimelineMetric> getTimelineMetrics() {
        return null;
    }
}

