/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.hadoop.mapreduce.jobhistory;

import java.util.Set;
import org.apache.avro.util.Utf8;
import shaded.org.apache.hadoop.classification.InterfaceAudience;
import shaded.org.apache.hadoop.classification.InterfaceStability;
import shaded.org.apache.hadoop.mapred.JobPriority;
import shaded.org.apache.hadoop.mapreduce.JobID;
import shaded.org.apache.hadoop.mapreduce.jobhistory.EventType;
import shaded.org.apache.hadoop.mapreduce.jobhistory.HistoryEvent;
import shaded.org.apache.hadoop.mapreduce.jobhistory.JobPriorityChange;
import shaded.org.apache.hadoop.util.StringUtils;
import shaded.org.apache.hadoop.yarn.api.records.timelineservice.TimelineEvent;
import shaded.org.apache.hadoop.yarn.api.records.timelineservice.TimelineMetric;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class JobPriorityChangeEvent
implements HistoryEvent {
    private JobPriorityChange datum = new JobPriorityChange();

    public JobPriorityChangeEvent(JobID id, JobPriority priority) {
        this.datum.setJobid((CharSequence)new Utf8(id.toString()));
        this.datum.setPriority((CharSequence)new Utf8(priority.name()));
    }

    JobPriorityChangeEvent() {
    }

    @Override
    public Object getDatum() {
        return this.datum;
    }

    @Override
    public void setDatum(Object datum) {
        this.datum = (JobPriorityChange)((Object)datum);
    }

    public JobID getJobId() {
        return JobID.forName(this.datum.getJobid().toString());
    }

    public JobPriority getPriority() {
        return JobPriority.valueOf(this.datum.getPriority().toString());
    }

    @Override
    public EventType getEventType() {
        return EventType.JOB_PRIORITY_CHANGED;
    }

    @Override
    public TimelineEvent toTimelineEvent() {
        TimelineEvent tEvent = new TimelineEvent();
        tEvent.setId(StringUtils.toUpperCase(this.getEventType().name()));
        tEvent.addInfo("PRIORITY", this.getPriority().toString());
        return tEvent;
    }

    @Override
    public Set<TimelineMetric> getTimelineMetrics() {
        return null;
    }
}

