/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.hadoop.mapreduce.jobhistory;

import shaded.org.apache.hadoop.mapreduce.v2.api.records.JobId;
import shaded.org.apache.hadoop.util.StringUtils;

public class JobSummary {
    private JobId jobId;
    private long jobSubmitTime;
    private long jobLaunchTime;
    private long firstMapTaskLaunchTime;
    private long firstReduceTaskLaunchTime;
    private long jobFinishTime;
    private int numFinishedMaps;
    private int numFailedMaps;
    private int numFinishedReduces;
    private int numFailedReduces;
    private int resourcesPerMap;
    private int resourcesPerReduce;
    private String user;
    private String queue;
    private String jobStatus;
    private long mapSlotSeconds;
    private long reduceSlotSeconds;
    private String jobName;
    static final char EQUALS = '=';
    static final char[] charsToEscape = new char[]{',', '=', '\\'};

    JobSummary() {
    }

    public JobId getJobId() {
        return this.jobId;
    }

    public void setJobId(JobId jobId) {
        this.jobId = jobId;
    }

    public long getJobSubmitTime() {
        return this.jobSubmitTime;
    }

    public void setJobSubmitTime(long jobSubmitTime) {
        this.jobSubmitTime = jobSubmitTime;
    }

    public long getJobLaunchTime() {
        return this.jobLaunchTime;
    }

    public void setJobLaunchTime(long jobLaunchTime) {
        this.jobLaunchTime = jobLaunchTime;
    }

    public long getFirstMapTaskLaunchTime() {
        return this.firstMapTaskLaunchTime;
    }

    public void setFirstMapTaskLaunchTime(long firstMapTaskLaunchTime) {
        this.firstMapTaskLaunchTime = firstMapTaskLaunchTime;
    }

    public long getFirstReduceTaskLaunchTime() {
        return this.firstReduceTaskLaunchTime;
    }

    public void setFirstReduceTaskLaunchTime(long firstReduceTaskLaunchTime) {
        this.firstReduceTaskLaunchTime = firstReduceTaskLaunchTime;
    }

    public long getJobFinishTime() {
        return this.jobFinishTime;
    }

    public void setJobFinishTime(long jobFinishTime) {
        this.jobFinishTime = jobFinishTime;
    }

    public int getNumFinishedMaps() {
        return this.numFinishedMaps;
    }

    public void setNumFinishedMaps(int numFinishedMaps) {
        this.numFinishedMaps = numFinishedMaps;
    }

    public int getNumFailedMaps() {
        return this.numFailedMaps;
    }

    public void setNumFailedMaps(int numFailedMaps) {
        this.numFailedMaps = numFailedMaps;
    }

    public int getResourcesPerMap() {
        return this.resourcesPerMap;
    }

    public void setResourcesPerMap(int resourcesPerMap) {
        this.resourcesPerMap = resourcesPerMap;
    }

    public int getNumFinishedReduces() {
        return this.numFinishedReduces;
    }

    public void setNumFinishedReduces(int numFinishedReduces) {
        this.numFinishedReduces = numFinishedReduces;
    }

    public int getNumFailedReduces() {
        return this.numFailedReduces;
    }

    public void setNumFailedReduces(int numFailedReduces) {
        this.numFailedReduces = numFailedReduces;
    }

    public int getResourcesPerReduce() {
        return this.resourcesPerReduce;
    }

    public void setResourcesPerReduce(int resourcesPerReduce) {
        this.resourcesPerReduce = resourcesPerReduce;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getQueue() {
        return this.queue;
    }

    public void setQueue(String queue) {
        this.queue = queue;
    }

    public String getJobStatus() {
        return this.jobStatus;
    }

    public void setJobStatus(String jobStatus) {
        this.jobStatus = jobStatus;
    }

    public long getMapSlotSeconds() {
        return this.mapSlotSeconds;
    }

    public void setMapSlotSeconds(long mapSlotSeconds) {
        this.mapSlotSeconds = mapSlotSeconds;
    }

    public long getReduceSlotSeconds() {
        return this.reduceSlotSeconds;
    }

    public void setReduceSlotSeconds(long reduceSlotSeconds) {
        this.reduceSlotSeconds = reduceSlotSeconds;
    }

    public String getJobName() {
        return this.jobName;
    }

    public void setJobName(String jobName) {
        this.jobName = jobName;
    }

    public String getJobSummaryString() {
        SummaryBuilder summary = new SummaryBuilder().add("jobId", this.jobId).add("submitTime", this.jobSubmitTime).add("launchTime", this.jobLaunchTime).add("firstMapTaskLaunchTime", this.firstMapTaskLaunchTime).add("firstReduceTaskLaunchTime", this.firstReduceTaskLaunchTime).add("finishTime", this.jobFinishTime).add("resourcesPerMap", this.resourcesPerMap).add("resourcesPerReduce", this.resourcesPerReduce).add("numMaps", this.numFinishedMaps + this.numFailedMaps).add("numReduces", this.numFinishedReduces + this.numFailedReduces).add("user", this.user).add("queue", this.queue).add("status", this.jobStatus).add("mapSlotSeconds", this.mapSlotSeconds).add("reduceSlotSeconds", this.reduceSlotSeconds).add("jobName", this.jobName);
        return summary.toString();
    }

    static class SummaryBuilder {
        final StringBuilder buffer = new StringBuilder();

        SummaryBuilder() {
        }

        SummaryBuilder add(String key, long value) {
            return this._add(key, Long.toString(value));
        }

        <T> SummaryBuilder add(String key, T value) {
            String escapedString = StringUtils.escapeString(String.valueOf(value), '\\', charsToEscape).replaceAll("\n", "\\\\n").replaceAll("\r", "\\\\r");
            return this._add(key, escapedString);
        }

        SummaryBuilder add(SummaryBuilder summary) {
            if (this.buffer.length() > 0) {
                this.buffer.append(',');
            }
            this.buffer.append((CharSequence)summary.buffer);
            return this;
        }

        SummaryBuilder _add(String key, String value) {
            if (this.buffer.length() > 0) {
                this.buffer.append(',');
            }
            this.buffer.append(key).append('=').append(value);
            return this;
        }

        public String toString() {
            return this.buffer.toString();
        }
    }
}

