/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.hadoop.mapreduce.jobhistory;

import java.util.Set;
import shaded.org.apache.hadoop.classification.InterfaceAudience;
import shaded.org.apache.hadoop.classification.InterfaceStability;
import shaded.org.apache.hadoop.mapreduce.TaskType;
import shaded.org.apache.hadoop.mapreduce.jobhistory.EventType;
import shaded.org.apache.hadoop.mapreduce.jobhistory.HistoryEvent;
import shaded.org.apache.hadoop.util.StringUtils;
import shaded.org.apache.hadoop.yarn.api.records.timelineservice.TimelineEvent;
import shaded.org.apache.hadoop.yarn.api.records.timelineservice.TimelineMetric;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class NormalizedResourceEvent
implements HistoryEvent {
    private long memory;
    private TaskType taskType;

    public NormalizedResourceEvent(TaskType taskType, long memory) {
        this.memory = memory;
        this.taskType = taskType;
    }

    public TaskType getTaskType() {
        return this.taskType;
    }

    public long getMemory() {
        return this.memory;
    }

    @Override
    public EventType getEventType() {
        return EventType.NORMALIZED_RESOURCE;
    }

    @Override
    public Object getDatum() {
        throw new UnsupportedOperationException("Not a seriable object");
    }

    @Override
    public void setDatum(Object datum) {
        throw new UnsupportedOperationException("Not a seriable object");
    }

    @Override
    public TimelineEvent toTimelineEvent() {
        TimelineEvent tEvent = new TimelineEvent();
        tEvent.setId(StringUtils.toUpperCase(this.getEventType().name()));
        tEvent.addInfo("MEMORY", "" + this.getMemory());
        tEvent.addInfo("TASK_TYPE", (Object)this.getTaskType());
        return tEvent;
    }

    @Override
    public Set<TimelineMetric> getTimelineMetrics() {
        return null;
    }
}

