/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.hadoop.mapreduce.lib.aggregate;

import java.util.ArrayList;
import shaded.org.apache.hadoop.classification.InterfaceAudience;
import shaded.org.apache.hadoop.classification.InterfaceStability;
import shaded.org.apache.hadoop.mapreduce.lib.aggregate.ValueAggregator;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class StringValueMax
implements ValueAggregator<String> {
    String maxVal = null;

    public StringValueMax() {
        this.reset();
    }

    @Override
    public void addNextValue(Object val) {
        String newVal = val.toString();
        if (this.maxVal == null || this.maxVal.compareTo(newVal) < 0) {
            this.maxVal = newVal;
        }
    }

    public String getVal() {
        return this.maxVal;
    }

    @Override
    public String getReport() {
        return this.maxVal;
    }

    @Override
    public void reset() {
        this.maxVal = null;
    }

    @Override
    public ArrayList<String> getCombinerOutput() {
        ArrayList<String> retv = new ArrayList<String>(1);
        retv.add(this.maxVal);
        return retv;
    }
}

