/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.hadoop.mapreduce.lib.aggregate;

import java.io.IOException;
import java.util.Map;
import shaded.org.apache.hadoop.classification.InterfaceAudience;
import shaded.org.apache.hadoop.classification.InterfaceStability;
import shaded.org.apache.hadoop.io.Text;
import shaded.org.apache.hadoop.io.Writable;
import shaded.org.apache.hadoop.io.WritableComparable;
import shaded.org.apache.hadoop.mapreduce.Mapper;
import shaded.org.apache.hadoop.mapreduce.lib.aggregate.ValueAggregatorDescriptor;
import shaded.org.apache.hadoop.mapreduce.lib.aggregate.ValueAggregatorJobBase;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class ValueAggregatorMapper<K1 extends WritableComparable<?>, V1 extends Writable>
extends Mapper<K1, V1, Text, Text> {
    @Override
    public void setup(Mapper.Context context) throws IOException, InterruptedException {
        ValueAggregatorJobBase.setup(context.getConfiguration());
    }

    @Override
    public void map(K1 key, V1 value, Mapper.Context context) throws IOException, InterruptedException {
        for (ValueAggregatorDescriptor ad : ValueAggregatorJobBase.aggregatorDescriptorList) {
            for (Map.Entry<Text, Text> en : ad.generateKeyValPairs(key, value)) {
                context.write(en.getKey(), en.getValue());
            }
        }
    }
}

