/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.hadoop.mapreduce.lib.input;

import java.io.IOException;
import shaded.org.apache.hadoop.classification.InterfaceAudience;
import shaded.org.apache.hadoop.classification.InterfaceStability;
import shaded.org.apache.hadoop.mapreduce.InputFormat;
import shaded.org.apache.hadoop.mapreduce.InputSplit;
import shaded.org.apache.hadoop.mapreduce.RecordReader;
import shaded.org.apache.hadoop.mapreduce.TaskAttemptContext;
import shaded.org.apache.hadoop.mapreduce.lib.input.TaggedInputSplit;
import shaded.org.apache.hadoop.util.ReflectionUtils;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class DelegatingRecordReader<K, V>
extends RecordReader<K, V> {
    RecordReader<K, V> originalRR;

    public DelegatingRecordReader(InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
        TaggedInputSplit taggedInputSplit = (TaggedInputSplit)split;
        InputFormat inputFormat = ReflectionUtils.newInstance(taggedInputSplit.getInputFormatClass(), context.getConfiguration());
        this.originalRR = inputFormat.createRecordReader(taggedInputSplit.getInputSplit(), context);
    }

    @Override
    public void close() throws IOException {
        this.originalRR.close();
    }

    @Override
    public K getCurrentKey() throws IOException, InterruptedException {
        return this.originalRR.getCurrentKey();
    }

    @Override
    public V getCurrentValue() throws IOException, InterruptedException {
        return this.originalRR.getCurrentValue();
    }

    @Override
    public float getProgress() throws IOException, InterruptedException {
        return this.originalRR.getProgress();
    }

    @Override
    public void initialize(InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
        this.originalRR.initialize(((TaggedInputSplit)split).getInputSplit(), context);
    }

    @Override
    public boolean nextKeyValue() throws IOException, InterruptedException {
        return this.originalRR.nextKeyValue();
    }
}

