/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.hadoop.mapreduce.lib.input;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import shaded.org.apache.hadoop.classification.InterfaceAudience;
import shaded.org.apache.hadoop.classification.InterfaceStability;
import shaded.org.apache.hadoop.fs.Path;
import shaded.org.apache.hadoop.io.Text;
import shaded.org.apache.hadoop.io.Writable;
import shaded.org.apache.hadoop.mapred.SplitLocationInfo;
import shaded.org.apache.hadoop.mapreduce.InputSplit;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class FileSplit
extends InputSplit
implements Writable {
    private Path file;
    private long start;
    private long length;
    private String[] hosts;
    private SplitLocationInfo[] hostInfos;

    public FileSplit() {
    }

    public FileSplit(Path file, long start, long length, String[] hosts) {
        this.file = file;
        this.start = start;
        this.length = length;
        this.hosts = hosts;
    }

    public FileSplit(Path file, long start, long length, String[] hosts, String[] inMemoryHosts) {
        this(file, start, length, hosts);
        this.hostInfos = new SplitLocationInfo[hosts.length];
        for (int i = 0; i < hosts.length; ++i) {
            boolean inMemory = false;
            for (String inMemoryHost : inMemoryHosts) {
                if (!inMemoryHost.equals(hosts[i])) continue;
                inMemory = true;
                break;
            }
            this.hostInfos[i] = new SplitLocationInfo(hosts[i], inMemory);
        }
    }

    public Path getPath() {
        return this.file;
    }

    public long getStart() {
        return this.start;
    }

    @Override
    public long getLength() {
        return this.length;
    }

    public String toString() {
        return this.file + ":" + this.start + "+" + this.length;
    }

    @Override
    public void write(DataOutput out) throws IOException {
        Text.writeString(out, this.file.toString());
        out.writeLong(this.start);
        out.writeLong(this.length);
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        this.file = new Path(Text.readString(in));
        this.start = in.readLong();
        this.length = in.readLong();
        this.hosts = null;
    }

    @Override
    public String[] getLocations() throws IOException {
        if (this.hosts == null) {
            return new String[0];
        }
        return this.hosts;
    }

    @Override
    @InterfaceStability.Evolving
    public SplitLocationInfo[] getLocationInfo() throws IOException {
        return this.hostInfos;
    }
}

