/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.hadoop.mapreduce.lib.input;

import java.io.IOException;
import shaded.org.apache.hadoop.classification.InterfaceAudience;
import shaded.org.apache.hadoop.classification.InterfaceStability;
import shaded.org.apache.hadoop.conf.Configuration;
import shaded.org.apache.hadoop.fs.Path;
import shaded.org.apache.hadoop.io.BytesWritable;
import shaded.org.apache.hadoop.io.LongWritable;
import shaded.org.apache.hadoop.io.compress.CompressionCodec;
import shaded.org.apache.hadoop.io.compress.CompressionCodecFactory;
import shaded.org.apache.hadoop.mapreduce.InputSplit;
import shaded.org.apache.hadoop.mapreduce.JobContext;
import shaded.org.apache.hadoop.mapreduce.RecordReader;
import shaded.org.apache.hadoop.mapreduce.TaskAttemptContext;
import shaded.org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import shaded.org.apache.hadoop.mapreduce.lib.input.FixedLengthRecordReader;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class FixedLengthInputFormat
extends FileInputFormat<LongWritable, BytesWritable> {
    public static final String FIXED_RECORD_LENGTH = "fixedlengthinputformat.record.length";

    public static void setRecordLength(Configuration conf, int recordLength) {
        conf.setInt(FIXED_RECORD_LENGTH, recordLength);
    }

    public static int getRecordLength(Configuration conf) {
        return conf.getInt(FIXED_RECORD_LENGTH, 0);
    }

    @Override
    public RecordReader<LongWritable, BytesWritable> createRecordReader(InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
        int recordLength = FixedLengthInputFormat.getRecordLength(context.getConfiguration());
        if (recordLength <= 0) {
            throw new IOException("Fixed record length " + recordLength + " is invalid.  It should be set to a value greater than zero");
        }
        return new FixedLengthRecordReader(recordLength);
    }

    @Override
    protected boolean isSplitable(JobContext context, Path file) {
        CompressionCodec codec = new CompressionCodecFactory(context.getConfiguration()).getCodec(file);
        return null == codec;
    }
}

