/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.hadoop.mapreduce.lib.input;

import java.io.IOException;
import shaded.org.apache.hadoop.classification.InterfaceAudience;
import shaded.org.apache.hadoop.classification.InterfaceStability;
import shaded.org.apache.hadoop.fs.Path;
import shaded.org.apache.hadoop.io.Text;
import shaded.org.apache.hadoop.io.compress.CompressionCodec;
import shaded.org.apache.hadoop.io.compress.CompressionCodecFactory;
import shaded.org.apache.hadoop.io.compress.SplittableCompressionCodec;
import shaded.org.apache.hadoop.mapreduce.InputSplit;
import shaded.org.apache.hadoop.mapreduce.JobContext;
import shaded.org.apache.hadoop.mapreduce.RecordReader;
import shaded.org.apache.hadoop.mapreduce.TaskAttemptContext;
import shaded.org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import shaded.org.apache.hadoop.mapreduce.lib.input.KeyValueLineRecordReader;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class KeyValueTextInputFormat
extends FileInputFormat<Text, Text> {
    @Override
    protected boolean isSplitable(JobContext context, Path file) {
        CompressionCodec codec = new CompressionCodecFactory(context.getConfiguration()).getCodec(file);
        if (null == codec) {
            return true;
        }
        return codec instanceof SplittableCompressionCodec;
    }

    @Override
    public RecordReader<Text, Text> createRecordReader(InputSplit genericSplit, TaskAttemptContext context) throws IOException {
        context.setStatus(genericSplit.toString());
        return new KeyValueLineRecordReader(context.getConfiguration());
    }
}

