/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.hadoop.mapreduce.lib.input;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import shaded.org.apache.hadoop.classification.InterfaceAudience;
import shaded.org.apache.hadoop.classification.InterfaceStability;
import shaded.org.apache.hadoop.conf.Configuration;
import shaded.org.apache.hadoop.fs.FSDataInputStream;
import shaded.org.apache.hadoop.fs.FileStatus;
import shaded.org.apache.hadoop.fs.FileSystem;
import shaded.org.apache.hadoop.fs.Path;
import shaded.org.apache.hadoop.io.LongWritable;
import shaded.org.apache.hadoop.io.Text;
import shaded.org.apache.hadoop.mapreduce.InputSplit;
import shaded.org.apache.hadoop.mapreduce.Job;
import shaded.org.apache.hadoop.mapreduce.JobContext;
import shaded.org.apache.hadoop.mapreduce.RecordReader;
import shaded.org.apache.hadoop.mapreduce.TaskAttemptContext;
import shaded.org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import shaded.org.apache.hadoop.mapreduce.lib.input.FileSplit;
import shaded.org.apache.hadoop.mapreduce.lib.input.LineRecordReader;
import shaded.org.apache.hadoop.util.LineReader;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class NLineInputFormat
extends FileInputFormat<LongWritable, Text> {
    public static final String LINES_PER_MAP = "mapreduce.input.lineinputformat.linespermap";

    @Override
    public RecordReader<LongWritable, Text> createRecordReader(InputSplit genericSplit, TaskAttemptContext context) throws IOException {
        context.setStatus(genericSplit.toString());
        return new LineRecordReader();
    }

    @Override
    public List<InputSplit> getSplits(JobContext job) throws IOException {
        ArrayList<InputSplit> splits = new ArrayList<InputSplit>();
        int numLinesPerSplit = NLineInputFormat.getNumLinesPerSplit(job);
        for (FileStatus status : this.listStatus(job)) {
            splits.addAll(NLineInputFormat.getSplitsForFile(status, job.getConfiguration(), numLinesPerSplit));
        }
        return splits;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<FileSplit> getSplitsForFile(FileStatus status, Configuration conf, int numLinesPerSplit) throws IOException {
        ArrayList<FileSplit> splits = new ArrayList<FileSplit>();
        Path fileName = status.getPath();
        if (status.isDirectory()) {
            throw new IOException("Not a file: " + fileName);
        }
        FileSystem fs = fileName.getFileSystem(conf);
        try (LineReader lr = null;){
            FSDataInputStream in = fs.open(fileName);
            lr = new LineReader((InputStream)in, conf);
            Text line = new Text();
            int numLines = 0;
            long begin = 0L;
            long length = 0L;
            int num = -1;
            while ((num = lr.readLine(line)) > 0) {
                length += (long)num;
                if (++numLines != numLinesPerSplit) continue;
                splits.add(NLineInputFormat.createFileSplit(fileName, begin, length));
                begin += length;
                length = 0L;
                numLines = 0;
            }
            if (numLines != 0) {
                splits.add(NLineInputFormat.createFileSplit(fileName, begin, length));
            }
        }
        return splits;
    }

    protected static FileSplit createFileSplit(Path fileName, long begin, long length) {
        return begin == 0L ? new FileSplit(fileName, begin, length - 1L, new String[0]) : new FileSplit(fileName, begin - 1L, length, new String[0]);
    }

    public static void setNumLinesPerSplit(Job job, int numLines) {
        job.getConfiguration().setInt(LINES_PER_MAP, numLines);
    }

    public static int getNumLinesPerSplit(JobContext job) {
        return job.getConfiguration().getInt(LINES_PER_MAP, 1);
    }
}

