/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.hadoop.mapreduce.lib.input;

import com.google.common.base.Charsets;
import shaded.org.apache.hadoop.classification.InterfaceAudience;
import shaded.org.apache.hadoop.classification.InterfaceStability;
import shaded.org.apache.hadoop.fs.Path;
import shaded.org.apache.hadoop.io.LongWritable;
import shaded.org.apache.hadoop.io.Text;
import shaded.org.apache.hadoop.io.compress.CompressionCodec;
import shaded.org.apache.hadoop.io.compress.CompressionCodecFactory;
import shaded.org.apache.hadoop.io.compress.SplittableCompressionCodec;
import shaded.org.apache.hadoop.mapreduce.InputSplit;
import shaded.org.apache.hadoop.mapreduce.JobContext;
import shaded.org.apache.hadoop.mapreduce.RecordReader;
import shaded.org.apache.hadoop.mapreduce.TaskAttemptContext;
import shaded.org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import shaded.org.apache.hadoop.mapreduce.lib.input.LineRecordReader;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class TextInputFormat
extends FileInputFormat<LongWritable, Text> {
    @Override
    public RecordReader<LongWritable, Text> createRecordReader(InputSplit split, TaskAttemptContext context) {
        String delimiter = context.getConfiguration().get("textinputformat.record.delimiter");
        byte[] recordDelimiterBytes = null;
        if (null != delimiter) {
            recordDelimiterBytes = delimiter.getBytes(Charsets.UTF_8);
        }
        return new LineRecordReader(recordDelimiterBytes);
    }

    @Override
    protected boolean isSplitable(JobContext context, Path file) {
        CompressionCodec codec = new CompressionCodecFactory(context.getConfiguration()).getCodec(file);
        if (null == codec) {
            return true;
        }
        return codec instanceof SplittableCompressionCodec;
    }
}

