/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.hadoop.mapreduce.split;

import java.io.IOException;
import java.util.Arrays;
import shaded.org.apache.hadoop.classification.InterfaceAudience;
import shaded.org.apache.hadoop.classification.InterfaceStability;
import shaded.org.apache.hadoop.conf.Configuration;
import shaded.org.apache.hadoop.fs.FSDataInputStream;
import shaded.org.apache.hadoop.fs.FileStatus;
import shaded.org.apache.hadoop.fs.FileSystem;
import shaded.org.apache.hadoop.fs.Path;
import shaded.org.apache.hadoop.io.WritableUtils;
import shaded.org.apache.hadoop.mapreduce.JobID;
import shaded.org.apache.hadoop.mapreduce.JobSubmissionFiles;
import shaded.org.apache.hadoop.mapreduce.split.JobSplit;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class SplitMetaInfoReader {
    public static JobSplit.TaskSplitMetaInfo[] readSplitMetaInfo(JobID jobId, FileSystem fs, Configuration conf, Path jobSubmitDir) throws IOException {
        long maxMetaInfoSize = conf.getLong("mapreduce.job.split.metainfo.maxsize", 10000000L);
        Path metaSplitFile = JobSubmissionFiles.getJobSplitMetaFile(jobSubmitDir);
        String jobSplitFile = JobSubmissionFiles.getJobSplitFile(jobSubmitDir).toString();
        FileStatus fStatus = fs.getFileStatus(metaSplitFile);
        if (maxMetaInfoSize > 0L && fStatus.getLen() > maxMetaInfoSize) {
            throw new IOException("Split metadata size exceeded " + maxMetaInfoSize + ". Aborting job " + jobId);
        }
        FSDataInputStream in = fs.open(metaSplitFile);
        byte[] header = new byte[JobSplit.META_SPLIT_FILE_HEADER.length];
        in.readFully(header);
        if (!Arrays.equals(JobSplit.META_SPLIT_FILE_HEADER, header)) {
            throw new IOException("Invalid header on split file");
        }
        int vers = WritableUtils.readVInt(in);
        if (vers != 1) {
            in.close();
            throw new IOException("Unsupported split version " + vers);
        }
        int numSplits = WritableUtils.readVInt(in);
        JobSplit.TaskSplitMetaInfo[] allSplitMetaInfo = new JobSplit.TaskSplitMetaInfo[numSplits];
        for (int i = 0; i < numSplits; ++i) {
            JobSplit.SplitMetaInfo splitMetaInfo = new JobSplit.SplitMetaInfo();
            splitMetaInfo.readFields(in);
            JobSplit.TaskSplitIndex splitIndex = new JobSplit.TaskSplitIndex(jobSplitFile, splitMetaInfo.getStartOffset());
            allSplitMetaInfo[i] = new JobSplit.TaskSplitMetaInfo(splitIndex, splitMetaInfo.getLocations(), splitMetaInfo.getInputDataLength());
        }
        in.close();
        return allSplitMetaInfo;
    }
}

