/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.hadoop.mapreduce.task.reduce;

import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.crypto.SecretKey;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import shaded.org.apache.hadoop.conf.Configuration;
import shaded.org.apache.hadoop.fs.FSDataInputStream;
import shaded.org.apache.hadoop.fs.FileSystem;
import shaded.org.apache.hadoop.fs.Path;
import shaded.org.apache.hadoop.io.IOUtils;
import shaded.org.apache.hadoop.mapred.IndexRecord;
import shaded.org.apache.hadoop.mapred.JobConf;
import shaded.org.apache.hadoop.mapred.MapOutputFile;
import shaded.org.apache.hadoop.mapred.Reporter;
import shaded.org.apache.hadoop.mapred.SpillRecord;
import shaded.org.apache.hadoop.mapreduce.CryptoUtils;
import shaded.org.apache.hadoop.mapreduce.TaskAttemptID;
import shaded.org.apache.hadoop.mapreduce.task.reduce.ExceptionReporter;
import shaded.org.apache.hadoop.mapreduce.task.reduce.Fetcher;
import shaded.org.apache.hadoop.mapreduce.task.reduce.MapHost;
import shaded.org.apache.hadoop.mapreduce.task.reduce.MapOutput;
import shaded.org.apache.hadoop.mapreduce.task.reduce.MergeManager;
import shaded.org.apache.hadoop.mapreduce.task.reduce.ShuffleClientMetrics;
import shaded.org.apache.hadoop.mapreduce.task.reduce.ShuffleSchedulerImpl;

class LocalFetcher<K, V>
extends Fetcher<K, V> {
    private static final Log LOG = LogFactory.getLog(LocalFetcher.class);
    private static final MapHost LOCALHOST = new MapHost("local", "local");
    private JobConf job;
    private Map<TaskAttemptID, MapOutputFile> localMapFiles;

    public LocalFetcher(JobConf job, TaskAttemptID reduceId, ShuffleSchedulerImpl<K, V> scheduler, MergeManager<K, V> merger, Reporter reporter, ShuffleClientMetrics metrics, ExceptionReporter exceptionReporter, SecretKey shuffleKey, Map<TaskAttemptID, MapOutputFile> localMapFiles) {
        super(job, reduceId, scheduler, merger, reporter, metrics, exceptionReporter, shuffleKey);
        this.job = job;
        this.localMapFiles = localMapFiles;
        this.setName("localfetcher#" + this.id);
        this.setDaemon(true);
    }

    @Override
    public void run() {
        HashSet<TaskAttemptID> maps = new HashSet<TaskAttemptID>();
        for (TaskAttemptID map : this.localMapFiles.keySet()) {
            maps.add(map);
        }
        while (maps.size() > 0) {
            try {
                this.merger.waitForResource();
                this.metrics.threadBusy();
                this.doCopy(maps);
                this.metrics.threadFree();
            }
            catch (InterruptedException i$) {
            }
            catch (Throwable t) {
                this.exceptionReporter.reportException(t);
            }
        }
    }

    private void doCopy(Set<TaskAttemptID> maps) throws IOException {
        Iterator<TaskAttemptID> iter = maps.iterator();
        while (iter.hasNext()) {
            TaskAttemptID map = iter.next();
            LOG.debug((Object)("LocalFetcher " + this.id + " going to fetch: " + map));
            if (!this.copyMapOutput(map)) break;
            iter.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean copyMapOutput(TaskAttemptID mapTaskId) throws IOException {
        Path mapOutputFileName = this.localMapFiles.get(mapTaskId).getOutputFile();
        Path indexFileName = mapOutputFileName.suffix(".index");
        SpillRecord sr = new SpillRecord(indexFileName, this.job);
        IndexRecord ir = sr.getIndex(this.reduce);
        long compressedLength = ir.partLength;
        long decompressedLength = ir.rawLength;
        compressedLength -= (long)CryptoUtils.cryptoPadding(this.job);
        MapOutput mapOutput = this.merger.reserve(mapTaskId, decompressedLength -= (long)CryptoUtils.cryptoPadding(this.job), this.id);
        if (mapOutput == null) {
            LOG.info((Object)("fetcher#" + this.id + " - MergeManager returned Status.WAIT ..."));
            return false;
        }
        LOG.info((Object)("localfetcher#" + this.id + " about to shuffle output of map " + mapOutput.getMapId() + " decomp: " + decompressedLength + " len: " + compressedLength + " to " + mapOutput.getDescription()));
        FileSystem localFs = FileSystem.getLocal(this.job).getRaw();
        FSDataInputStream inStream = localFs.open(mapOutputFileName);
        try {
            inStream = CryptoUtils.wrapIfNecessary((Configuration)this.job, inStream);
            inStream.seek(ir.startOffset + (long)CryptoUtils.cryptoPadding(this.job));
            mapOutput.shuffle(LOCALHOST, inStream, compressedLength, decompressedLength, this.metrics, this.reporter);
        }
        catch (Throwable throwable) {
            IOUtils.cleanup(LOG, inStream);
            throw throwable;
        }
        IOUtils.cleanup(LOG, inStream);
        this.scheduler.copySucceeded(mapTaskId, LOCALHOST, compressedLength, 0L, 0L, mapOutput);
        return true;
    }
}

