/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.hadoop.mapreduce.task.reduce;

import java.io.IOException;
import java.util.Map;
import shaded.org.apache.hadoop.classification.InterfaceAudience;
import shaded.org.apache.hadoop.classification.InterfaceStability;
import shaded.org.apache.hadoop.mapred.JobConf;
import shaded.org.apache.hadoop.mapred.MapOutputFile;
import shaded.org.apache.hadoop.mapred.RawKeyValueIterator;
import shaded.org.apache.hadoop.mapred.Reporter;
import shaded.org.apache.hadoop.mapred.ShuffleConsumerPlugin;
import shaded.org.apache.hadoop.mapred.Task;
import shaded.org.apache.hadoop.mapred.TaskStatus;
import shaded.org.apache.hadoop.mapred.TaskUmbilicalProtocol;
import shaded.org.apache.hadoop.mapreduce.TaskAttemptID;
import shaded.org.apache.hadoop.mapreduce.task.reduce.EventFetcher;
import shaded.org.apache.hadoop.mapreduce.task.reduce.ExceptionReporter;
import shaded.org.apache.hadoop.mapreduce.task.reduce.Fetcher;
import shaded.org.apache.hadoop.mapreduce.task.reduce.LocalFetcher;
import shaded.org.apache.hadoop.mapreduce.task.reduce.MergeManager;
import shaded.org.apache.hadoop.mapreduce.task.reduce.MergeManagerImpl;
import shaded.org.apache.hadoop.mapreduce.task.reduce.ShuffleClientMetrics;
import shaded.org.apache.hadoop.mapreduce.task.reduce.ShuffleSchedulerImpl;
import shaded.org.apache.hadoop.util.Progress;

@InterfaceAudience.LimitedPrivate(value={"MapReduce"})
@InterfaceStability.Unstable
public class Shuffle<K, V>
implements ShuffleConsumerPlugin<K, V>,
ExceptionReporter {
    private static final int PROGRESS_FREQUENCY = 2000;
    private static final int MAX_EVENTS_TO_FETCH = 10000;
    private static final int MIN_EVENTS_TO_FETCH = 100;
    private static final int MAX_RPC_OUTSTANDING_EVENTS = 3000000;
    private ShuffleConsumerPlugin.Context context;
    private TaskAttemptID reduceId;
    private JobConf jobConf;
    private Reporter reporter;
    private ShuffleClientMetrics metrics;
    private TaskUmbilicalProtocol umbilical;
    private ShuffleSchedulerImpl<K, V> scheduler;
    private MergeManager<K, V> merger;
    private Throwable throwable = null;
    private String throwingThreadName = null;
    private Progress copyPhase;
    private TaskStatus taskStatus;
    private Task reduceTask;
    private Map<TaskAttemptID, MapOutputFile> localMapFiles;

    @Override
    public void init(ShuffleConsumerPlugin.Context context) {
        this.context = context;
        this.reduceId = context.getReduceId();
        this.jobConf = context.getJobConf();
        this.umbilical = context.getUmbilical();
        this.reporter = context.getReporter();
        this.metrics = new ShuffleClientMetrics(this.reduceId, this.jobConf);
        this.copyPhase = context.getCopyPhase();
        this.taskStatus = context.getStatus();
        this.reduceTask = context.getReduceTask();
        this.localMapFiles = context.getLocalMapFiles();
        this.scheduler = new ShuffleSchedulerImpl(this.jobConf, this.taskStatus, this.reduceId, this, this.copyPhase, context.getShuffledMapsCounter(), context.getReduceShuffleBytes(), context.getFailedShuffleCounter());
        this.merger = this.createMergeManager(context);
    }

    protected MergeManager<K, V> createMergeManager(ShuffleConsumerPlugin.Context context) {
        return new MergeManagerImpl(this.reduceId, this.jobConf, context.getLocalFS(), context.getLocalDirAllocator(), this.reporter, context.getCodec(), context.getCombinerClass(), context.getCombineCollector(), context.getSpilledRecordsCounter(), context.getReduceCombineInputCounter(), context.getMergedMapOutputsCounter(), this, context.getMergePhase(), context.getMapOutputFile());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RawKeyValueIterator run() throws IOException, InterruptedException {
        int eventsPerReducer = Math.max(100, 3000000 / this.jobConf.getNumReduceTasks());
        int maxEventsToFetch = Math.min(10000, eventsPerReducer);
        EventFetcher<K, V> eventFetcher = new EventFetcher<K, V>(this.reduceId, this.umbilical, this.scheduler, this, maxEventsToFetch);
        eventFetcher.start();
        boolean isLocal = this.localMapFiles != null;
        int numFetchers = isLocal ? 1 : this.jobConf.getInt("mapreduce.reduce.shuffle.parallelcopies", 5);
        Fetcher[] fetchers = new Fetcher[numFetchers];
        if (isLocal) {
            fetchers[0] = new LocalFetcher<K, V>(this.jobConf, this.reduceId, this.scheduler, this.merger, this.reporter, this.metrics, (ExceptionReporter)this, this.reduceTask.getShuffleSecret(), this.localMapFiles);
            fetchers[0].start();
        } else {
            for (int i = 0; i < numFetchers; ++i) {
                fetchers[i] = new Fetcher<K, V>(this.jobConf, this.reduceId, this.scheduler, this.merger, this.reporter, this.metrics, this, this.reduceTask.getShuffleSecret());
                fetchers[i].start();
            }
        }
        while (!this.scheduler.waitUntilDone(2000)) {
            this.reporter.progress();
            Shuffle i = this;
            synchronized (i) {
                if (this.throwable != null) {
                    throw new ShuffleError("error in shuffle in " + this.throwingThreadName, this.throwable);
                }
            }
        }
        eventFetcher.shutDown();
        for (Fetcher fetcher : fetchers) {
            fetcher.shutDown();
        }
        this.scheduler.close();
        this.copyPhase.complete();
        this.taskStatus.setPhase(TaskStatus.Phase.SORT);
        this.reduceTask.statusUpdate(this.umbilical);
        RawKeyValueIterator kvIter = null;
        try {
            kvIter = this.merger.close();
        }
        catch (Throwable e) {
            throw new ShuffleError("Error while doing final merge ", e);
        }
        Shuffle shuffle = this;
        synchronized (shuffle) {
            if (this.throwable != null) {
                throw new ShuffleError("error in shuffle in " + this.throwingThreadName, this.throwable);
            }
        }
        return kvIter;
    }

    @Override
    public void close() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void reportException(Throwable t) {
        if (this.throwable == null) {
            this.throwable = t;
            this.throwingThreadName = Thread.currentThread().getName();
            ShuffleSchedulerImpl<K, V> shuffleSchedulerImpl = this.scheduler;
            synchronized (shuffleSchedulerImpl) {
                this.scheduler.notifyAll();
            }
        }
    }

    public static class ShuffleError
    extends IOException {
        private static final long serialVersionUID = 5753909320586607881L;

        ShuffleError(String msg, Throwable t) {
            super(msg, t);
        }
    }
}

