/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.hadoop.mapreduce.util;

import java.util.concurrent.TimeUnit;
import shaded.org.apache.hadoop.conf.Configuration;

public final class MRJobConfUtil {
    public static final String REDACTION_REPLACEMENT_VAL = "*********(redacted)";
    public static final float TASK_REPORT_INTERVAL_TO_TIMEOUT_RATIO = 0.01f;
    public static final double PROGRESS_MIN_DELTA_FACTOR = 100.0;
    private static volatile Double progressMinDeltaThreshold = null;
    private static volatile Long progressMaxWaitDeltaTimeThreshold = null;

    public static void redact(Configuration conf) {
        for (String prop : conf.getTrimmedStringCollection("mapreduce.job.redacted-properties")) {
            conf.set(prop, REDACTION_REPLACEMENT_VAL);
        }
    }

    private MRJobConfUtil() {
    }

    public static long getTaskProgressReportInterval(Configuration conf) {
        long taskHeartbeatTimeOut = conf.getLong("mapreduce.task.timeout", 300000L);
        return conf.getLong("mapreduce.task.progress-report.interval", (long)(0.01f * (float)taskHeartbeatTimeOut));
    }

    public static void setTaskLogProgressDeltaThresholds(Configuration conf) {
        if (progressMinDeltaThreshold == null) {
            progressMinDeltaThreshold = new Double(100.0 * conf.getDouble("mapreduce.task.log.progress.delta.threshold", 0.05));
        }
        if (progressMaxWaitDeltaTimeThreshold == null) {
            progressMaxWaitDeltaTimeThreshold = TimeUnit.SECONDS.toMillis(conf.getLong("mapreduce.task.log.progress.wait.interval-seconds", 60L));
        }
    }

    public static double getTaskProgressMinDeltaThreshold() {
        if (progressMinDeltaThreshold == null) {
            return 5.0;
        }
        return progressMinDeltaThreshold;
    }

    public static long getTaskProgressWaitDeltaTimeThreshold() {
        if (progressMaxWaitDeltaTimeThreshold == null) {
            return TimeUnit.SECONDS.toMillis(60L);
        }
        return progressMaxWaitDeltaTimeThreshold;
    }

    public static double convertTaskProgressToFactor(float progress) {
        return Math.floor((double)progress * 100.0);
    }
}

