/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.hadoop.mapreduce.v2.app.client;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import shaded.org.apache.hadoop.conf.Configuration;
import shaded.org.apache.hadoop.http.HttpConfig;
import shaded.org.apache.hadoop.ipc.Server;
import shaded.org.apache.hadoop.mapreduce.Counters;
import shaded.org.apache.hadoop.mapreduce.JobACL;
import shaded.org.apache.hadoop.mapreduce.TypeConverter;
import shaded.org.apache.hadoop.mapreduce.v2.api.MRClientProtocol;
import shaded.org.apache.hadoop.mapreduce.v2.api.protocolrecords.CancelDelegationTokenRequest;
import shaded.org.apache.hadoop.mapreduce.v2.api.protocolrecords.CancelDelegationTokenResponse;
import shaded.org.apache.hadoop.mapreduce.v2.api.protocolrecords.FailTaskAttemptRequest;
import shaded.org.apache.hadoop.mapreduce.v2.api.protocolrecords.FailTaskAttemptResponse;
import shaded.org.apache.hadoop.mapreduce.v2.api.protocolrecords.GetCountersRequest;
import shaded.org.apache.hadoop.mapreduce.v2.api.protocolrecords.GetCountersResponse;
import shaded.org.apache.hadoop.mapreduce.v2.api.protocolrecords.GetDelegationTokenRequest;
import shaded.org.apache.hadoop.mapreduce.v2.api.protocolrecords.GetDelegationTokenResponse;
import shaded.org.apache.hadoop.mapreduce.v2.api.protocolrecords.GetDiagnosticsRequest;
import shaded.org.apache.hadoop.mapreduce.v2.api.protocolrecords.GetDiagnosticsResponse;
import shaded.org.apache.hadoop.mapreduce.v2.api.protocolrecords.GetJobReportRequest;
import shaded.org.apache.hadoop.mapreduce.v2.api.protocolrecords.GetJobReportResponse;
import shaded.org.apache.hadoop.mapreduce.v2.api.protocolrecords.GetTaskAttemptCompletionEventsRequest;
import shaded.org.apache.hadoop.mapreduce.v2.api.protocolrecords.GetTaskAttemptCompletionEventsResponse;
import shaded.org.apache.hadoop.mapreduce.v2.api.protocolrecords.GetTaskAttemptReportRequest;
import shaded.org.apache.hadoop.mapreduce.v2.api.protocolrecords.GetTaskAttemptReportResponse;
import shaded.org.apache.hadoop.mapreduce.v2.api.protocolrecords.GetTaskReportRequest;
import shaded.org.apache.hadoop.mapreduce.v2.api.protocolrecords.GetTaskReportResponse;
import shaded.org.apache.hadoop.mapreduce.v2.api.protocolrecords.GetTaskReportsRequest;
import shaded.org.apache.hadoop.mapreduce.v2.api.protocolrecords.GetTaskReportsResponse;
import shaded.org.apache.hadoop.mapreduce.v2.api.protocolrecords.KillJobRequest;
import shaded.org.apache.hadoop.mapreduce.v2.api.protocolrecords.KillJobResponse;
import shaded.org.apache.hadoop.mapreduce.v2.api.protocolrecords.KillTaskAttemptRequest;
import shaded.org.apache.hadoop.mapreduce.v2.api.protocolrecords.KillTaskAttemptResponse;
import shaded.org.apache.hadoop.mapreduce.v2.api.protocolrecords.KillTaskRequest;
import shaded.org.apache.hadoop.mapreduce.v2.api.protocolrecords.KillTaskResponse;
import shaded.org.apache.hadoop.mapreduce.v2.api.protocolrecords.RenewDelegationTokenRequest;
import shaded.org.apache.hadoop.mapreduce.v2.api.protocolrecords.RenewDelegationTokenResponse;
import shaded.org.apache.hadoop.mapreduce.v2.api.records.JobId;
import shaded.org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptId;
import shaded.org.apache.hadoop.mapreduce.v2.api.records.TaskId;
import shaded.org.apache.hadoop.mapreduce.v2.api.records.TaskType;
import shaded.org.apache.hadoop.mapreduce.v2.app.AppContext;
import shaded.org.apache.hadoop.mapreduce.v2.app.client.ClientService;
import shaded.org.apache.hadoop.mapreduce.v2.app.job.Job;
import shaded.org.apache.hadoop.mapreduce.v2.app.job.Task;
import shaded.org.apache.hadoop.mapreduce.v2.app.job.TaskAttempt;
import shaded.org.apache.hadoop.mapreduce.v2.app.job.event.JobDiagnosticsUpdateEvent;
import shaded.org.apache.hadoop.mapreduce.v2.app.job.event.JobEvent;
import shaded.org.apache.hadoop.mapreduce.v2.app.job.event.JobEventType;
import shaded.org.apache.hadoop.mapreduce.v2.app.job.event.TaskAttemptDiagnosticsUpdateEvent;
import shaded.org.apache.hadoop.mapreduce.v2.app.job.event.TaskAttemptEvent;
import shaded.org.apache.hadoop.mapreduce.v2.app.job.event.TaskAttemptEventType;
import shaded.org.apache.hadoop.mapreduce.v2.app.job.event.TaskEvent;
import shaded.org.apache.hadoop.mapreduce.v2.app.job.event.TaskEventType;
import shaded.org.apache.hadoop.mapreduce.v2.app.security.authorize.MRAMPolicyProvider;
import shaded.org.apache.hadoop.mapreduce.v2.app.webapp.AMWebApp;
import shaded.org.apache.hadoop.net.NetUtils;
import shaded.org.apache.hadoop.security.AccessControlException;
import shaded.org.apache.hadoop.security.UserGroupInformation;
import shaded.org.apache.hadoop.security.authorize.PolicyProvider;
import shaded.org.apache.hadoop.security.token.SecretManager;
import shaded.org.apache.hadoop.service.AbstractService;
import shaded.org.apache.hadoop.yarn.event.Event;
import shaded.org.apache.hadoop.yarn.exceptions.YarnException;
import shaded.org.apache.hadoop.yarn.factories.RecordFactory;
import shaded.org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import shaded.org.apache.hadoop.yarn.ipc.YarnRPC;
import shaded.org.apache.hadoop.yarn.webapp.WebApp;
import shaded.org.apache.hadoop.yarn.webapp.WebApps;

public class MRClientService
extends AbstractService
implements ClientService {
    static final Log LOG = LogFactory.getLog(MRClientService.class);
    private MRClientProtocol protocolHandler;
    private Server server;
    private WebApp webApp;
    private InetSocketAddress bindAddress;
    private AppContext appContext;

    public MRClientService(AppContext appContext) {
        super(MRClientService.class.getName());
        this.appContext = appContext;
        this.protocolHandler = new MRClientProtocolHandler();
    }

    @Override
    protected void serviceStart() throws Exception {
        Configuration conf = this.getConfig();
        YarnRPC rpc = YarnRPC.create((Configuration)conf);
        InetSocketAddress address = new InetSocketAddress(0);
        this.server = rpc.getServer(MRClientProtocol.class, (Object)this.protocolHandler, address, conf, (SecretManager)this.appContext.getClientToAMTokenSecretManager(), conf.getInt("yarn.app.mapreduce.am.job.client.thread-count", 1), "yarn.app.mapreduce.am.job.client.port-range");
        if (conf.getBoolean("hadoop.security.authorization", false)) {
            this.refreshServiceAcls(conf, new MRAMPolicyProvider());
        }
        this.server.start();
        this.bindAddress = NetUtils.createSocketAddrForHost(this.appContext.getNMHostname(), this.server.getListenerAddress().getPort());
        LOG.info((Object)("Instantiated MRClientService at " + this.bindAddress));
        try {
            this.webApp = WebApps.$for((String)"mapreduce", AppContext.class, (Object)this.appContext, (String)"ws").withHttpPolicy(conf, HttpConfig.Policy.HTTP_ONLY).withPortRange(conf, "yarn.app.mapreduce.am.webapp.port-range").start((WebApp)new AMWebApp());
        }
        catch (Exception e) {
            LOG.error((Object)"Webapps failed to start. Ignoring for now:", (Throwable)e);
        }
        super.serviceStart();
    }

    void refreshServiceAcls(Configuration configuration, PolicyProvider policyProvider) {
        this.server.refreshServiceAcl(configuration, policyProvider);
    }

    @Override
    protected void serviceStop() throws Exception {
        if (this.server != null) {
            this.server.stop();
        }
        if (this.webApp != null) {
            this.webApp.stop();
        }
        super.serviceStop();
    }

    @Override
    public InetSocketAddress getBindAddress() {
        return this.bindAddress;
    }

    @Override
    public int getHttpPort() {
        return this.webApp.port();
    }

    public KillTaskAttemptResponse forceKillTaskAttempt(KillTaskAttemptRequest request) throws YarnException, IOException {
        return this.protocolHandler.killTaskAttempt(request);
    }

    public WebApp getWebApp() {
        return this.webApp;
    }

    class MRClientProtocolHandler
    implements MRClientProtocol {
        private RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);
        private final Object getTaskReportsLock = new Object();

        MRClientProtocolHandler() {
        }

        public InetSocketAddress getConnectAddress() {
            return MRClientService.this.getBindAddress();
        }

        private Job verifyAndGetJob(JobId jobID, JobACL accessType, boolean exceptionThrow) throws IOException {
            Job job = MRClientService.this.appContext.getJob(jobID);
            if (job == null && exceptionThrow) {
                throw new IOException("Unknown Job " + jobID);
            }
            UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
            if (job != null && !job.checkAccess(ugi, accessType)) {
                throw new AccessControlException("User " + ugi.getShortUserName() + " cannot perform operation " + accessType.name() + " on " + jobID);
            }
            return job;
        }

        private Task verifyAndGetTask(TaskId taskID, JobACL accessType) throws IOException {
            Task task = this.verifyAndGetJob(taskID.getJobId(), accessType, true).getTask(taskID);
            if (task == null) {
                throw new IOException("Unknown Task " + taskID);
            }
            return task;
        }

        private TaskAttempt verifyAndGetAttempt(TaskAttemptId attemptID, JobACL accessType) throws IOException {
            TaskAttempt attempt = this.verifyAndGetTask(attemptID.getTaskId(), accessType).getAttempt(attemptID);
            if (attempt == null) {
                throw new IOException("Unknown TaskAttempt " + attemptID);
            }
            return attempt;
        }

        public GetCountersResponse getCounters(GetCountersRequest request) throws IOException {
            JobId jobId = request.getJobId();
            Job job = this.verifyAndGetJob(jobId, JobACL.VIEW_JOB, true);
            GetCountersResponse response = this.recordFactory.newRecordInstance(GetCountersResponse.class);
            response.setCounters(TypeConverter.toYarn((Counters)job.getAllCounters()));
            return response;
        }

        public GetJobReportResponse getJobReport(GetJobReportRequest request) throws IOException {
            JobId jobId = request.getJobId();
            Job job = this.verifyAndGetJob(jobId, JobACL.VIEW_JOB, false);
            GetJobReportResponse response = this.recordFactory.newRecordInstance(GetJobReportResponse.class);
            if (job != null) {
                response.setJobReport(job.getReport());
            } else {
                response.setJobReport(null);
            }
            return response;
        }

        public GetTaskAttemptReportResponse getTaskAttemptReport(GetTaskAttemptReportRequest request) throws IOException {
            TaskAttemptId taskAttemptId = request.getTaskAttemptId();
            GetTaskAttemptReportResponse response = this.recordFactory.newRecordInstance(GetTaskAttemptReportResponse.class);
            response.setTaskAttemptReport(this.verifyAndGetAttempt(taskAttemptId, JobACL.VIEW_JOB).getReport());
            return response;
        }

        public GetTaskReportResponse getTaskReport(GetTaskReportRequest request) throws IOException {
            TaskId taskId = request.getTaskId();
            GetTaskReportResponse response = this.recordFactory.newRecordInstance(GetTaskReportResponse.class);
            response.setTaskReport(this.verifyAndGetTask(taskId, JobACL.VIEW_JOB).getReport());
            return response;
        }

        public GetTaskAttemptCompletionEventsResponse getTaskAttemptCompletionEvents(GetTaskAttemptCompletionEventsRequest request) throws IOException {
            JobId jobId = request.getJobId();
            int fromEventId = request.getFromEventId();
            int maxEvents = request.getMaxEvents();
            Job job = this.verifyAndGetJob(jobId, JobACL.VIEW_JOB, true);
            GetTaskAttemptCompletionEventsResponse response = this.recordFactory.newRecordInstance(GetTaskAttemptCompletionEventsResponse.class);
            response.addAllCompletionEvents(Arrays.asList(job.getTaskAttemptCompletionEvents(fromEventId, maxEvents)));
            return response;
        }

        public KillJobResponse killJob(KillJobRequest request) throws IOException {
            JobId jobId = request.getJobId();
            UserGroupInformation callerUGI = UserGroupInformation.getCurrentUser();
            String message = "Kill job " + jobId + " received from " + callerUGI + " at " + Server.getRemoteAddress();
            LOG.info((Object)message);
            this.verifyAndGetJob(jobId, JobACL.MODIFY_JOB, false);
            MRClientService.this.appContext.getEventHandler().handle((Event)new JobDiagnosticsUpdateEvent(jobId, message));
            MRClientService.this.appContext.getEventHandler().handle((Event)new JobEvent(jobId, JobEventType.JOB_KILL));
            KillJobResponse response = this.recordFactory.newRecordInstance(KillJobResponse.class);
            return response;
        }

        public KillTaskResponse killTask(KillTaskRequest request) throws IOException {
            TaskId taskId = request.getTaskId();
            UserGroupInformation callerUGI = UserGroupInformation.getCurrentUser();
            String message = "Kill task " + taskId + " received from " + callerUGI + " at " + Server.getRemoteAddress();
            LOG.info((Object)message);
            this.verifyAndGetTask(taskId, JobACL.MODIFY_JOB);
            MRClientService.this.appContext.getEventHandler().handle((Event)new TaskEvent(taskId, TaskEventType.T_KILL));
            KillTaskResponse response = this.recordFactory.newRecordInstance(KillTaskResponse.class);
            return response;
        }

        public KillTaskAttemptResponse killTaskAttempt(KillTaskAttemptRequest request) throws IOException {
            TaskAttemptId taskAttemptId = request.getTaskAttemptId();
            UserGroupInformation callerUGI = UserGroupInformation.getCurrentUser();
            String message = "Kill task attempt " + taskAttemptId + " received from " + callerUGI + " at " + Server.getRemoteAddress();
            LOG.info((Object)message);
            this.verifyAndGetAttempt(taskAttemptId, JobACL.MODIFY_JOB);
            MRClientService.this.appContext.getEventHandler().handle((Event)new TaskAttemptDiagnosticsUpdateEvent(taskAttemptId, message));
            MRClientService.this.appContext.getEventHandler().handle((Event)new TaskAttemptEvent(taskAttemptId, TaskAttemptEventType.TA_KILL));
            KillTaskAttemptResponse response = this.recordFactory.newRecordInstance(KillTaskAttemptResponse.class);
            return response;
        }

        public GetDiagnosticsResponse getDiagnostics(GetDiagnosticsRequest request) throws IOException {
            TaskAttemptId taskAttemptId = request.getTaskAttemptId();
            GetDiagnosticsResponse response = this.recordFactory.newRecordInstance(GetDiagnosticsResponse.class);
            response.addAllDiagnostics(this.verifyAndGetAttempt(taskAttemptId, JobACL.VIEW_JOB).getDiagnostics());
            return response;
        }

        public FailTaskAttemptResponse failTaskAttempt(FailTaskAttemptRequest request) throws IOException {
            TaskAttemptId taskAttemptId = request.getTaskAttemptId();
            UserGroupInformation callerUGI = UserGroupInformation.getCurrentUser();
            String message = "Fail task attempt " + taskAttemptId + " received from " + callerUGI + " at " + Server.getRemoteAddress();
            LOG.info((Object)message);
            this.verifyAndGetAttempt(taskAttemptId, JobACL.MODIFY_JOB);
            MRClientService.this.appContext.getEventHandler().handle((Event)new TaskAttemptDiagnosticsUpdateEvent(taskAttemptId, message));
            MRClientService.this.appContext.getEventHandler().handle((Event)new TaskAttemptEvent(taskAttemptId, TaskAttemptEventType.TA_FAILMSG_BY_CLIENT));
            FailTaskAttemptResponse response = this.recordFactory.newRecordInstance(FailTaskAttemptResponse.class);
            return response;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public GetTaskReportsResponse getTaskReports(GetTaskReportsRequest request) throws IOException {
            JobId jobId = request.getJobId();
            TaskType taskType = request.getTaskType();
            GetTaskReportsResponse response = this.recordFactory.newRecordInstance(GetTaskReportsResponse.class);
            Job job = this.verifyAndGetJob(jobId, JobACL.VIEW_JOB, true);
            Collection<Task> tasks = job.getTasks(taskType).values();
            LOG.info((Object)("Getting task report for " + taskType + "   " + jobId + ". Report-size will be " + tasks.size()));
            Object object = this.getTaskReportsLock;
            synchronized (object) {
                for (Task task : tasks) {
                    response.addTaskReport(task.getReport());
                }
            }
            return response;
        }

        public GetDelegationTokenResponse getDelegationToken(GetDelegationTokenRequest request) throws IOException {
            throw new IOException("MR AM not authorized to issue delegation token");
        }

        public RenewDelegationTokenResponse renewDelegationToken(RenewDelegationTokenRequest request) throws IOException {
            throw new IOException("MR AM not authorized to renew delegation token");
        }

        public CancelDelegationTokenResponse cancelDelegationToken(CancelDelegationTokenRequest request) throws IOException {
            throw new IOException("MR AM not authorized to cancel delegation token");
        }
    }
}

