/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.hadoop.mapreduce.v2.app.job.impl;

import shaded.org.apache.hadoop.fs.Path;
import shaded.org.apache.hadoop.mapred.JobConf;
import shaded.org.apache.hadoop.mapred.ReduceTaskAttemptImpl;
import shaded.org.apache.hadoop.mapreduce.security.token.JobTokenIdentifier;
import shaded.org.apache.hadoop.mapreduce.v2.api.records.JobId;
import shaded.org.apache.hadoop.mapreduce.v2.api.records.TaskType;
import shaded.org.apache.hadoop.mapreduce.v2.app.AppContext;
import shaded.org.apache.hadoop.mapreduce.v2.app.TaskAttemptListener;
import shaded.org.apache.hadoop.mapreduce.v2.app.job.impl.TaskAttemptImpl;
import shaded.org.apache.hadoop.mapreduce.v2.app.job.impl.TaskImpl;
import shaded.org.apache.hadoop.mapreduce.v2.app.metrics.MRAppMetrics;
import shaded.org.apache.hadoop.security.Credentials;
import shaded.org.apache.hadoop.security.token.Token;
import shaded.org.apache.hadoop.yarn.event.EventHandler;
import shaded.org.apache.hadoop.yarn.util.Clock;

public class ReduceTaskImpl
extends TaskImpl {
    private final int numMapTasks;

    public ReduceTaskImpl(JobId jobId, int partition, EventHandler eventHandler, Path jobFile, JobConf conf, int numMapTasks, TaskAttemptListener taskAttemptListener, Token<JobTokenIdentifier> jobToken, Credentials credentials, Clock clock, int appAttemptId, MRAppMetrics metrics, AppContext appContext) {
        super(jobId, TaskType.REDUCE, partition, eventHandler, jobFile, conf, taskAttemptListener, jobToken, credentials, clock, appAttemptId, metrics, appContext);
        this.numMapTasks = numMapTasks;
    }

    @Override
    protected int getMaxAttempts() {
        return this.conf.getInt("mapreduce.reduce.maxattempts", 4);
    }

    @Override
    protected TaskAttemptImpl createAttempt() {
        return new ReduceTaskAttemptImpl(this.getID(), this.nextAttemptNumber, this.eventHandler, this.jobFile, this.partition, this.numMapTasks, this.conf, this.taskAttemptListener, (Token<JobTokenIdentifier>)this.jobToken, this.credentials, this.clock, this.appContext);
    }

    @Override
    public TaskType getType() {
        return TaskType.REDUCE;
    }
}

