/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.hadoop.mapreduce.v2.app.launcher;

import shaded.org.apache.hadoop.mapred.Task;
import shaded.org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptId;
import shaded.org.apache.hadoop.mapreduce.v2.app.launcher.ContainerLauncher;
import shaded.org.apache.hadoop.mapreduce.v2.app.launcher.ContainerLauncherEvent;
import shaded.org.apache.hadoop.util.StringInterner;
import shaded.org.apache.hadoop.yarn.api.records.Container;
import shaded.org.apache.hadoop.yarn.api.records.ContainerLaunchContext;

public class ContainerRemoteLaunchEvent
extends ContainerLauncherEvent {
    private final Container allocatedContainer;
    private final ContainerLaunchContext containerLaunchContext;
    private final Task task;

    public ContainerRemoteLaunchEvent(TaskAttemptId taskAttemptID, ContainerLaunchContext containerLaunchContext, Container allocatedContainer, Task remoteTask) {
        super(taskAttemptID, allocatedContainer.getId(), StringInterner.weakIntern(allocatedContainer.getNodeId().toString()), allocatedContainer.getContainerToken(), ContainerLauncher.EventType.CONTAINER_REMOTE_LAUNCH);
        this.allocatedContainer = allocatedContainer;
        this.containerLaunchContext = containerLaunchContext;
        this.task = remoteTask;
    }

    public ContainerLaunchContext getContainerLaunchContext() {
        return this.containerLaunchContext;
    }

    public Container getAllocatedContainer() {
        return this.allocatedContainer;
    }

    public Task getRemoteTask() {
        return this.task;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj);
    }
}

