/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.hadoop.mapreduce.v2.app.rm;

import shaded.org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptId;
import shaded.org.apache.hadoop.mapreduce.v2.app.rm.ContainerAllocator;
import shaded.org.apache.hadoop.mapreduce.v2.app.rm.ContainerAllocatorEvent;
import shaded.org.apache.hadoop.yarn.api.records.Resource;

public class ContainerRequestEvent
extends ContainerAllocatorEvent {
    private final Resource capability;
    private final String[] hosts;
    private final String[] racks;
    private boolean earlierAttemptFailed = false;

    public ContainerRequestEvent(TaskAttemptId attemptID, Resource capability, String[] hosts, String[] racks) {
        super(attemptID, ContainerAllocator.EventType.CONTAINER_REQ);
        this.capability = capability;
        this.hosts = hosts;
        this.racks = racks;
    }

    ContainerRequestEvent(TaskAttemptId attemptID, Resource capability) {
        this(attemptID, capability, new String[0], new String[0]);
        this.earlierAttemptFailed = true;
    }

    public static ContainerRequestEvent createContainerRequestEventForFailedContainer(TaskAttemptId attemptID, Resource capability) {
        return new ContainerRequestEvent(attemptID, capability);
    }

    public Resource getCapability() {
        return this.capability;
    }

    public String[] getHosts() {
        return this.hosts;
    }

    public String[] getRacks() {
        return this.racks;
    }

    public boolean getEarlierAttemptFailed() {
        return this.earlierAttemptFailed;
    }
}

