/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.hadoop.metrics2;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import shaded.org.apache.hadoop.classification.InterfaceAudience;
import shaded.org.apache.hadoop.classification.InterfaceStability;
import shaded.org.apache.hadoop.metrics2.MetricsInfo;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class MetricsTag
implements MetricsInfo {
    private final MetricsInfo info;
    private final String value;

    public MetricsTag(MetricsInfo info, String value) {
        this.info = (MetricsInfo)Preconditions.checkNotNull((Object)info, (Object)"tag info");
        this.value = value;
    }

    @Override
    public String name() {
        return this.info.name();
    }

    @Override
    public String description() {
        return this.info.description();
    }

    public MetricsInfo info() {
        return this.info;
    }

    public String value() {
        return this.value;
    }

    public boolean equals(Object obj) {
        if (obj instanceof MetricsTag) {
            MetricsTag other = (MetricsTag)obj;
            return Objects.equal((Object)this.info, (Object)other.info()) && Objects.equal((Object)this.value, (Object)other.value());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.info, this.value});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(32);
        sb.append(this.getClass().getSimpleName());
        sb.append("{info=");
        sb.append(this.info);
        sb.append(", value=");
        sb.append(this.value());
        return sb.append('}').toString();
    }
}

