/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.hadoop.metrics2.impl;

import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import shaded.org.apache.hadoop.metrics2.AbstractMetric;
import shaded.org.apache.hadoop.metrics2.MetricsCollector;
import shaded.org.apache.hadoop.metrics2.MetricsFilter;
import shaded.org.apache.hadoop.metrics2.MetricsInfo;
import shaded.org.apache.hadoop.metrics2.MetricsRecordBuilder;
import shaded.org.apache.hadoop.metrics2.MetricsTag;
import shaded.org.apache.hadoop.metrics2.impl.MetricCounterInt;
import shaded.org.apache.hadoop.metrics2.impl.MetricCounterLong;
import shaded.org.apache.hadoop.metrics2.impl.MetricGaugeDouble;
import shaded.org.apache.hadoop.metrics2.impl.MetricGaugeFloat;
import shaded.org.apache.hadoop.metrics2.impl.MetricGaugeInt;
import shaded.org.apache.hadoop.metrics2.impl.MetricGaugeLong;
import shaded.org.apache.hadoop.metrics2.impl.MetricsRecordImpl;
import shaded.org.apache.hadoop.metrics2.impl.MsInfo;
import shaded.org.apache.hadoop.metrics2.lib.Interns;
import shaded.org.apache.hadoop.util.Time;

class MetricsRecordBuilderImpl
extends MetricsRecordBuilder {
    private final MetricsCollector parent;
    private final long timestamp;
    private final MetricsInfo recInfo;
    private final List<AbstractMetric> metrics;
    private final List<MetricsTag> tags;
    private final MetricsFilter recordFilter;
    private final MetricsFilter metricFilter;
    private final boolean acceptable;

    MetricsRecordBuilderImpl(MetricsCollector parent, MetricsInfo info, MetricsFilter rf, MetricsFilter mf, boolean acceptable) {
        this.parent = parent;
        this.timestamp = Time.now();
        this.recInfo = info;
        this.metrics = Lists.newArrayList();
        this.tags = Lists.newArrayList();
        this.recordFilter = rf;
        this.metricFilter = mf;
        this.acceptable = acceptable;
    }

    @Override
    public MetricsCollector parent() {
        return this.parent;
    }

    @Override
    public MetricsRecordBuilderImpl tag(MetricsInfo info, String value) {
        if (this.acceptable) {
            this.tags.add(Interns.tag(info, value));
        }
        return this;
    }

    @Override
    public MetricsRecordBuilderImpl add(MetricsTag tag) {
        this.tags.add(tag);
        return this;
    }

    @Override
    public MetricsRecordBuilderImpl add(AbstractMetric metric) {
        this.metrics.add(metric);
        return this;
    }

    @Override
    public MetricsRecordBuilderImpl addCounter(MetricsInfo info, int value) {
        if (this.acceptable && (this.metricFilter == null || this.metricFilter.accepts(info.name()))) {
            this.metrics.add(new MetricCounterInt(info, value));
        }
        return this;
    }

    @Override
    public MetricsRecordBuilderImpl addCounter(MetricsInfo info, long value) {
        if (this.acceptable && (this.metricFilter == null || this.metricFilter.accepts(info.name()))) {
            this.metrics.add(new MetricCounterLong(info, value));
        }
        return this;
    }

    @Override
    public MetricsRecordBuilderImpl addGauge(MetricsInfo info, int value) {
        if (this.acceptable && (this.metricFilter == null || this.metricFilter.accepts(info.name()))) {
            this.metrics.add(new MetricGaugeInt(info, value));
        }
        return this;
    }

    @Override
    public MetricsRecordBuilderImpl addGauge(MetricsInfo info, long value) {
        if (this.acceptable && (this.metricFilter == null || this.metricFilter.accepts(info.name()))) {
            this.metrics.add(new MetricGaugeLong(info, value));
        }
        return this;
    }

    @Override
    public MetricsRecordBuilderImpl addGauge(MetricsInfo info, float value) {
        if (this.acceptable && (this.metricFilter == null || this.metricFilter.accepts(info.name()))) {
            this.metrics.add(new MetricGaugeFloat(info, value));
        }
        return this;
    }

    @Override
    public MetricsRecordBuilderImpl addGauge(MetricsInfo info, double value) {
        if (this.acceptable && (this.metricFilter == null || this.metricFilter.accepts(info.name()))) {
            this.metrics.add(new MetricGaugeDouble(info, value));
        }
        return this;
    }

    @Override
    public MetricsRecordBuilderImpl setContext(String value) {
        return this.tag(MsInfo.Context, value);
    }

    public MetricsRecordImpl getRecord() {
        if (this.acceptable && (this.recordFilter == null || this.recordFilter.accepts(this.tags))) {
            return new MetricsRecordImpl(this.recInfo, this.timestamp, this.tags(), this.metrics());
        }
        return null;
    }

    List<MetricsTag> tags() {
        return Collections.unmodifiableList(this.tags);
    }

    List<AbstractMetric> metrics() {
        return Collections.unmodifiableList(this.metrics);
    }
}

