/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.hadoop.metrics2.lib;

import java.util.concurrent.atomic.AtomicInteger;
import shaded.org.apache.hadoop.classification.InterfaceAudience;
import shaded.org.apache.hadoop.classification.InterfaceStability;
import shaded.org.apache.hadoop.metrics2.MetricsInfo;
import shaded.org.apache.hadoop.metrics2.MetricsRecordBuilder;
import shaded.org.apache.hadoop.metrics2.lib.MutableGauge;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class MutableGaugeInt
extends MutableGauge {
    private AtomicInteger value = new AtomicInteger();

    MutableGaugeInt(MetricsInfo info, int initValue) {
        super(info);
        this.value.set(initValue);
    }

    public int value() {
        return this.value.get();
    }

    @Override
    public void incr() {
        this.incr(1);
    }

    public void incr(int delta) {
        this.value.addAndGet(delta);
        this.setChanged();
    }

    @Override
    public void decr() {
        this.decr(1);
    }

    public void decr(int delta) {
        this.value.addAndGet(-delta);
        this.setChanged();
    }

    public void set(int value) {
        this.value.set(value);
        this.setChanged();
    }

    @Override
    public void snapshot(MetricsRecordBuilder builder, boolean all) {
        if (all || this.changed()) {
            builder.addGauge(this.info(), this.value());
            this.clearChanged();
        }
    }
}

