/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.hadoop.record.compiler;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.commons.io.Charsets;
import org.apache.commons.io.output.FileWriterWithEncoding;
import shaded.org.apache.hadoop.record.compiler.CodeGenerator;
import shaded.org.apache.hadoop.record.compiler.JFile;
import shaded.org.apache.hadoop.record.compiler.JRecord;
import shaded.org.apache.hadoop.util.StringUtils;

class CppGenerator
extends CodeGenerator {
    CppGenerator() {
    }

    @Override
    void genCode(String name, ArrayList<JFile> ilist, ArrayList<JRecord> rlist, String destDir, ArrayList<String> options) throws IOException {
        name = new File(destDir, new File(name).getName()).getAbsolutePath();
        try (FileWriterWithEncoding cc = new FileWriterWithEncoding(name + ".cc", Charsets.UTF_8);
             FileWriterWithEncoding hh = new FileWriterWithEncoding(name + ".hh", Charsets.UTF_8);){
            String fileName = new File(name).getName();
            hh.write("#ifndef __" + StringUtils.toUpperCase(fileName).replace('.', '_') + "__\n");
            hh.write("#define __" + StringUtils.toUpperCase(fileName).replace('.', '_') + "__\n");
            hh.write("#include \"recordio.hh\"\n");
            hh.write("#include \"recordTypeInfo.hh\"\n");
            Iterator<Object> iter = ilist.iterator();
            while (iter.hasNext()) {
                hh.write("#include \"" + iter.next().getName() + ".hh\"\n");
            }
            cc.write("#include \"" + fileName + ".hh\"\n");
            cc.write("#include \"utils.hh\"\n");
            iter = rlist.iterator();
            while (iter.hasNext()) {
                ((JRecord)iter.next()).genCppCode((Writer)hh, (Writer)cc, options);
            }
            hh.write("#endif //" + StringUtils.toUpperCase(fileName).replace('.', '_') + "__\n");
        }
    }
}

