/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.hadoop.security;

import java.io.IOException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shaded.org.apache.hadoop.security.GroupMappingServiceProvider;
import shaded.org.apache.hadoop.security.JniBasedUnixGroupsMapping;
import shaded.org.apache.hadoop.security.ShellBasedUnixGroupsMapping;
import shaded.org.apache.hadoop.util.NativeCodeLoader;
import shaded.org.apache.hadoop.util.PerformanceAdvisory;

public class JniBasedUnixGroupsMappingWithFallback
implements GroupMappingServiceProvider {
    private static final Logger LOG = LoggerFactory.getLogger(JniBasedUnixGroupsMappingWithFallback.class);
    private GroupMappingServiceProvider impl;

    public JniBasedUnixGroupsMappingWithFallback() {
        if (NativeCodeLoader.isNativeCodeLoaded()) {
            this.impl = new JniBasedUnixGroupsMapping();
        } else {
            PerformanceAdvisory.LOG.debug("Falling back to shell based");
            this.impl = new ShellBasedUnixGroupsMapping();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Group mapping impl=" + this.impl.getClass().getName());
        }
    }

    @Override
    public List<String> getGroups(String user) throws IOException {
        return this.impl.getGroups(user);
    }

    @Override
    public void cacheGroupsRefresh() throws IOException {
        this.impl.cacheGroupsRefresh();
    }

    @Override
    public void cacheGroupsAdd(List<String> groups) throws IOException {
        this.impl.cacheGroupsAdd(groups);
    }
}

