/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.hadoop.security;

import java.net.InetAddress;
import java.util.Map;
import java.util.TreeMap;
import shaded.org.apache.hadoop.conf.Configurable;
import shaded.org.apache.hadoop.conf.Configuration;
import shaded.org.apache.hadoop.security.SaslRpcServer;
import shaded.org.apache.hadoop.util.ReflectionUtils;
import shaded.org.apache.hadoop.util.StringUtils;

public class SaslPropertiesResolver
implements Configurable {
    private Map<String, String> properties;
    Configuration conf;

    public static SaslPropertiesResolver getInstance(Configuration conf) {
        Class<SaslPropertiesResolver> clazz = conf.getClass("hadoop.security.saslproperties.resolver.class", SaslPropertiesResolver.class, SaslPropertiesResolver.class);
        return ReflectionUtils.newInstance(clazz, conf);
    }

    @Override
    public void setConf(Configuration conf) {
        this.conf = conf;
        this.properties = new TreeMap<String, String>();
        String[] qop = conf.getTrimmedStrings("hadoop.rpc.protection", SaslRpcServer.QualityOfProtection.AUTHENTICATION.toString());
        for (int i = 0; i < qop.length; ++i) {
            qop[i] = SaslRpcServer.QualityOfProtection.valueOf(StringUtils.toUpperCase(qop[i])).getSaslQop();
        }
        this.properties.put("javax.security.sasl.qop", StringUtils.join((CharSequence)",", qop));
        this.properties.put("javax.security.sasl.server.authentication", "true");
    }

    @Override
    public Configuration getConf() {
        return this.conf;
    }

    public Map<String, String> getDefaultProperties() {
        return this.properties;
    }

    public Map<String, String> getServerProperties(InetAddress clientAddress) {
        return this.properties;
    }

    public Map<String, String> getServerProperties(InetAddress clientAddress, int ingressPort) {
        return this.getServerProperties(clientAddress);
    }

    public Map<String, String> getClientProperties(InetAddress serverAddress) {
        return this.properties;
    }

    public Map<String, String> getClientProperties(InetAddress serverAddress, int ingressPort) {
        return this.getClientProperties(serverAddress);
    }

    static Map<String, String> getSaslProperties(Configuration conf, String configKey, SaslRpcServer.QualityOfProtection defaultQOP) {
        TreeMap<String, String> saslProps = new TreeMap<String, String>();
        String[] qop = conf.getStrings(configKey, defaultQOP.toString());
        for (int i = 0; i < qop.length; ++i) {
            qop[i] = SaslRpcServer.QualityOfProtection.valueOf(StringUtils.toUpperCase(qop[i])).getSaslQop();
        }
        saslProps.put("javax.security.sasl.qop", StringUtils.join((CharSequence)",", qop));
        saslProps.put("javax.security.sasl.server.authentication", "true");
        return saslProps;
    }
}

