/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.hadoop.security.token.delegation.web;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shaded.org.apache.hadoop.classification.InterfaceAudience;
import shaded.org.apache.hadoop.classification.InterfaceStability;
import shaded.org.apache.hadoop.conf.Configuration;
import shaded.org.apache.hadoop.io.Text;
import shaded.org.apache.hadoop.security.UserGroupInformation;
import shaded.org.apache.hadoop.security.authentication.client.AuthenticationException;
import shaded.org.apache.hadoop.security.authentication.server.AuthenticationHandler;
import shaded.org.apache.hadoop.security.authentication.server.AuthenticationToken;
import shaded.org.apache.hadoop.security.authorize.AuthorizationException;
import shaded.org.apache.hadoop.security.authorize.ProxyUsers;
import shaded.org.apache.hadoop.security.token.Token;
import shaded.org.apache.hadoop.security.token.delegation.AbstractDelegationTokenIdentifier;
import shaded.org.apache.hadoop.security.token.delegation.AbstractDelegationTokenSecretManager;
import shaded.org.apache.hadoop.security.token.delegation.web.DelegationTokenAuthenticationFilter;
import shaded.org.apache.hadoop.security.token.delegation.web.DelegationTokenAuthenticator;
import shaded.org.apache.hadoop.security.token.delegation.web.DelegationTokenManager;
import shaded.org.apache.hadoop.security.token.delegation.web.ServletUtils;
import shaded.org.apache.hadoop.util.HttpExceptionUtils;
import shaded.org.apache.hadoop.util.StringUtils;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public abstract class DelegationTokenAuthenticationHandler
implements AuthenticationHandler {
    private static final Logger LOG = LoggerFactory.getLogger(DelegationTokenAuthenticationHandler.class);
    protected static final String TYPE_POSTFIX = "-dt";
    public static final String PREFIX = "delegation-token.";
    public static final String TOKEN_KIND = "delegation-token.token-kind";
    private static final Set<String> DELEGATION_TOKEN_OPS = new HashSet<String>();
    public static final String DELEGATION_TOKEN_UGI_ATTRIBUTE = "hadoop.security.delegation-token.ugi";
    private AuthenticationHandler authHandler;
    private DelegationTokenManager tokenManager;
    private String authType;
    private static final String ENTER;

    public DelegationTokenAuthenticationHandler(AuthenticationHandler handler) {
        this.authHandler = handler;
        this.authType = handler.getType();
    }

    @VisibleForTesting
    DelegationTokenManager getTokenManager() {
        return this.tokenManager;
    }

    AuthenticationHandler getAuthHandler() {
        return this.authHandler;
    }

    @Override
    public void init(Properties config) throws ServletException {
        this.authHandler.init(config);
        this.initTokenManager(config);
    }

    public void setExternalDelegationTokenSecretManager(AbstractDelegationTokenSecretManager secretManager) {
        this.tokenManager.setExternalDelegationTokenSecretManager(secretManager);
    }

    @VisibleForTesting
    public void initTokenManager(Properties config) {
        Configuration conf = new Configuration(false);
        for (Map.Entry<Object, Object> entry : config.entrySet()) {
            conf.set((String)entry.getKey(), (String)entry.getValue());
        }
        String tokenKind = conf.get(TOKEN_KIND);
        if (tokenKind == null) {
            throw new IllegalArgumentException("The configuration does not define the token kind");
        }
        tokenKind = tokenKind.trim();
        this.tokenManager = new DelegationTokenManager(conf, new Text(tokenKind));
        this.tokenManager.init();
    }

    @Override
    public void destroy() {
        this.tokenManager.destroy();
        this.authHandler.destroy();
    }

    @Override
    public String getType() {
        return this.authType;
    }

    protected final boolean isManagementOperation(HttpServletRequest request) throws IOException {
        String op = ServletUtils.getParameter(request, "op");
        op = op != null ? StringUtils.toUpperCase(op) : null;
        return DELEGATION_TOKEN_OPS.contains(op) && !request.getMethod().equals("OPTIONS");
    }

    @Override
    public boolean managementOperation(AuthenticationToken token, HttpServletRequest request, HttpServletResponse response) throws IOException, AuthenticationException {
        boolean requestContinues = true;
        LOG.trace("Processing operation for req=({}), token: {}", (Object)request, (Object)token);
        String op = ServletUtils.getParameter(request, "op");
        String string = op = op != null ? StringUtils.toUpperCase(op) : null;
        if (this.isManagementOperation(request)) {
            DelegationTokenAuthenticator.DelegationTokenOperation dtOp = DelegationTokenAuthenticator.DelegationTokenOperation.valueOf(op);
            if (dtOp.getHttpMethod().equals(request.getMethod())) {
                boolean doManagement;
                if (dtOp.requiresKerberosCredentials() && token == null) {
                    token = this.authHandler.authenticate(request, response);
                    LOG.trace("Got token: {}.", (Object)token);
                    if (token == null) {
                        requestContinues = false;
                        doManagement = false;
                    } else {
                        doManagement = true;
                    }
                } else {
                    doManagement = true;
                }
                if (doManagement) {
                    UserGroupInformation requestUgi = token != null ? UserGroupInformation.createRemoteUser(token.getUserName()) : null;
                    String doAsUser = DelegationTokenAuthenticationFilter.getDoAs(request);
                    if (requestUgi != null && doAsUser != null) {
                        requestUgi = UserGroupInformation.createProxyUser(doAsUser, requestUgi);
                        try {
                            ProxyUsers.authorize(requestUgi, request.getRemoteAddr());
                        }
                        catch (AuthorizationException ex) {
                            HttpExceptionUtils.createServletExceptionResponse(response, 403, ex);
                            return false;
                        }
                    }
                    HashMap<String, Long> map = null;
                    switch (dtOp) {
                        case GETDELEGATIONTOKEN: {
                            if (requestUgi == null) {
                                throw new IllegalStateException("request UGI cannot be NULL");
                            }
                            String renewer = ServletUtils.getParameter(request, "renewer");
                            String service = ServletUtils.getParameter(request, "service");
                            try {
                                Token<? extends AbstractDelegationTokenIdentifier> dToken = this.tokenManager.createToken(requestUgi, renewer, service);
                                map = DelegationTokenAuthenticationHandler.delegationTokenToJSON(dToken);
                                break;
                            }
                            catch (IOException ex) {
                                throw new AuthenticationException(ex.toString(), ex);
                            }
                        }
                        case RENEWDELEGATIONTOKEN: {
                            if (requestUgi == null) {
                                throw new IllegalStateException("request UGI cannot be NULL");
                            }
                            String tokenToRenew = ServletUtils.getParameter(request, "token");
                            if (tokenToRenew == null) {
                                response.sendError(400, MessageFormat.format("Operation [{0}] requires the parameter [{1}]", new Object[]{dtOp, "token"}));
                                requestContinues = false;
                                break;
                            }
                            Token dt = new Token();
                            try {
                                dt.decodeFromUrlString(tokenToRenew);
                                long expirationTime = this.tokenManager.renewToken(dt, requestUgi.getShortUserName());
                                map = new HashMap<String, Long>();
                                map.put("long", expirationTime);
                                break;
                            }
                            catch (IOException ex) {
                                throw new AuthenticationException(ex.toString(), ex);
                            }
                        }
                        case CANCELDELEGATIONTOKEN: {
                            String tokenToCancel = ServletUtils.getParameter(request, "token");
                            if (tokenToCancel == null) {
                                response.sendError(400, MessageFormat.format("Operation [{0}] requires the parameter [{1}]", new Object[]{dtOp, "token"}));
                                requestContinues = false;
                                break;
                            }
                            Token dt = new Token();
                            try {
                                dt.decodeFromUrlString(tokenToCancel);
                                this.tokenManager.cancelToken(dt, requestUgi != null ? requestUgi.getShortUserName() : null);
                                break;
                            }
                            catch (IOException ex) {
                                response.sendError(404, "Invalid delegation token, cannot cancel");
                                requestContinues = false;
                            }
                        }
                    }
                    if (requestContinues) {
                        response.setStatus(200);
                        if (map != null) {
                            response.setContentType("application/json");
                            PrintWriter writer = response.getWriter();
                            ObjectMapper jsonMapper = new ObjectMapper();
                            jsonMapper.writeValue((Writer)writer, (Object)map);
                            ((Writer)writer).write(ENTER);
                            ((Writer)writer).flush();
                        }
                        requestContinues = false;
                    }
                }
            } else {
                response.sendError(400, MessageFormat.format("Wrong HTTP method [{0}] for operation [{1}], it should be [{2}]", new Object[]{request.getMethod(), dtOp, dtOp.getHttpMethod()}));
                requestContinues = false;
            }
        }
        return requestContinues;
    }

    private static Map delegationTokenToJSON(Token token) throws IOException {
        LinkedHashMap<String, String> json = new LinkedHashMap<String, String>();
        json.put("urlString", token.encodeToUrlString());
        LinkedHashMap<String, LinkedHashMap<String, String>> response = new LinkedHashMap<String, LinkedHashMap<String, String>>();
        response.put("Token", json);
        return response;
    }

    @Override
    public AuthenticationToken authenticate(HttpServletRequest request, HttpServletResponse response) throws IOException, AuthenticationException {
        AuthenticationToken token;
        String delegationParam = this.getDelegationToken(request);
        if (delegationParam != null) {
            LOG.debug("Authenticating with dt param: {}", (Object)delegationParam);
            try {
                Token dt = new Token();
                dt.decodeFromUrlString(delegationParam);
                UserGroupInformation ugi = this.tokenManager.verifyToken(dt);
                String shortName = ugi.getShortUserName();
                token = new AuthenticationToken(shortName, ugi.getUserName(), this.getType());
                token.setExpires(0L);
                request.setAttribute(DELEGATION_TOKEN_UGI_ATTRIBUTE, (Object)ugi);
            }
            catch (Throwable ex) {
                token = null;
                HttpExceptionUtils.createServletExceptionResponse(response, 403, new AuthenticationException(ex));
            }
        } else {
            LOG.debug("Falling back to {} (req={})", this.authHandler.getClass(), (Object)request);
            token = this.authHandler.authenticate(request, response);
        }
        return token;
    }

    private String getDelegationToken(HttpServletRequest request) throws IOException {
        String dToken = request.getHeader("X-Hadoop-Delegation-Token");
        if (dToken == null) {
            dToken = ServletUtils.getParameter(request, "delegation");
        }
        return dToken;
    }

    static {
        DELEGATION_TOKEN_OPS.add(DelegationTokenAuthenticator.DelegationTokenOperation.GETDELEGATIONTOKEN.toString());
        DELEGATION_TOKEN_OPS.add(DelegationTokenAuthenticator.DelegationTokenOperation.RENEWDELEGATIONTOKEN.toString());
        DELEGATION_TOKEN_OPS.add(DelegationTokenAuthenticator.DelegationTokenOperation.CANCELDELEGATIONTOKEN.toString());
        ENTER = System.getProperty("line.separator");
    }
}

