/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.hadoop.service.launcher;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shaded.org.apache.hadoop.conf.Configuration;
import shaded.org.apache.hadoop.net.NetUtils;
import shaded.org.apache.hadoop.service.Service;
import shaded.org.apache.hadoop.service.launcher.HadoopUncaughtExceptionHandler;
import shaded.org.apache.hadoop.service.launcher.InterruptEscalator;
import shaded.org.apache.hadoop.service.launcher.LaunchableService;
import shaded.org.apache.hadoop.service.launcher.LauncherArguments;
import shaded.org.apache.hadoop.service.launcher.LauncherExitCodes;
import shaded.org.apache.hadoop.service.launcher.ServiceLaunchException;
import shaded.org.apache.hadoop.service.launcher.ServiceShutdownHook;
import shaded.org.apache.hadoop.util.ExitCodeProvider;
import shaded.org.apache.hadoop.util.ExitUtil;
import shaded.org.apache.hadoop.util.GenericOptionsParser;
import shaded.org.apache.hadoop.util.StringUtils;

public class ServiceLauncher<S extends Service>
implements LauncherExitCodes,
LauncherArguments,
Thread.UncaughtExceptionHandler {
    private static final Logger LOG = LoggerFactory.getLogger(ServiceLauncher.class);
    protected static final int SHUTDOWN_PRIORITY = 30;
    public static final String NAME = "ServiceLauncher";
    protected static final String USAGE_NAME = "Usage: ServiceLauncher";
    protected static final String USAGE_SERVICE_ARGUMENTS = "service-classname <service arguments>";
    public static final String USAGE_MESSAGE = "Usage: ServiceLauncher [--conf <conf file>] [--hadoopconf <configuration classname>] service-classname <service arguments>";
    private static final int SHUTDOWN_TIME_ON_INTERRUPT = 30000;
    private volatile S service;
    private int serviceExitCode;
    private ExitUtil.ExitException serviceException;
    private InterruptEscalator interruptEscalator;
    private Configuration configuration;
    private String serviceName;
    private String serviceClassName = "";
    protected static final String[] DEFAULT_CONFIGS = new String[]{"shaded.org.apache.hadoop.conf.Configuration", "shaded.org.apache.hadoop.hdfs.HdfsConfiguration", "shaded.org.apache.hadoop.yarn.conf.YarnConfiguration"};
    private List<String> confClassnames = new ArrayList<String>(DEFAULT_CONFIGS.length);
    private List<URL> confResourceUrls = new ArrayList<URL>(1);
    private Options commandOptions;

    public ServiceLauncher(String serviceClassName) {
        this(serviceClassName, serviceClassName);
    }

    public ServiceLauncher(String serviceName, String serviceClassName) {
        this.serviceClassName = serviceClassName;
        this.serviceName = serviceName;
        this.confClassnames.addAll(Arrays.asList(DEFAULT_CONFIGS));
    }

    public final S getService() {
        return this.service;
    }

    protected void setService(S s) {
        this.service = s;
    }

    public final Configuration getConfiguration() {
        return this.configuration;
    }

    public final int getServiceExitCode() {
        return this.serviceExitCode;
    }

    public final ExitUtil.ExitException getServiceException() {
        return this.serviceException;
    }

    private boolean isClassnameDefined() {
        return this.serviceClassName != null && !this.serviceClassName.isEmpty();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("\"ServiceLauncher for \"");
        sb.append(this.serviceName);
        if (this.isClassnameDefined()) {
            sb.append(", serviceClassName='").append(this.serviceClassName).append('\'');
        }
        if (this.service != null) {
            sb.append(", service=").append(this.service);
        }
        return sb.toString();
    }

    public void launchServiceAndExit(List<String> args) {
        ExitUtil.ExitException exitException;
        StringBuilder builder = new StringBuilder();
        for (String arg : args) {
            builder.append('\"').append(arg).append("\" ");
        }
        String argumentString = builder.toString();
        if (LOG.isDebugEnabled()) {
            LOG.debug(ServiceLauncher.startupShutdownMessage(this.serviceName, args));
            LOG.debug(argumentString);
        }
        this.registerFailureHandling();
        this.loadConfigurationClasses();
        Configuration conf = this.createConfiguration();
        for (URL resourceUrl : this.confResourceUrls) {
            conf.addResource(resourceUrl);
        }
        this.bindCommandOptions();
        try {
            List<String> processedArgs = this.extractCommandOptions(conf, args);
            exitException = this.launchService(conf, processedArgs, true, true);
        }
        catch (ExitUtil.ExitException e) {
            exitException = e;
            this.noteException(exitException);
        }
        if (exitException.getExitCode() != 0) {
            System.err.println(this.getUsageMessage());
            System.err.println("Command: " + argumentString);
        }
        System.out.flush();
        System.err.flush();
        this.exit(exitException);
    }

    protected void bindCommandOptions() {
        this.commandOptions = this.createOptions();
    }

    void noteException(ExitUtil.ExitException exitException) {
        LOG.debug("Exception raised", (Throwable)exitException);
        this.serviceExitCode = exitException.getExitCode();
        this.serviceException = exitException;
    }

    protected String getUsageMessage() {
        String message = USAGE_MESSAGE;
        if (this.commandOptions != null) {
            message = "Usage: ServiceLauncher " + this.commandOptions.toString() + " " + USAGE_SERVICE_ARGUMENTS;
        }
        return message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Options createOptions() {
        Class<OptionBuilder> clazz = OptionBuilder.class;
        synchronized (OptionBuilder.class) {
            Options options = new Options();
            OptionBuilder.withArgName((String)"configuration file");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"specify an application configuration file");
            OptionBuilder.withLongOpt((String)"conf");
            Option oconf = OptionBuilder.create((String)"conf");
            OptionBuilder.withArgName((String)"configuration classname");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"Classname of a Hadoop Configuration subclass to load");
            OptionBuilder.withLongOpt((String)"hadoopconf");
            Option confclass = OptionBuilder.create((String)"hadoopconf");
            OptionBuilder.withArgName((String)"property=value");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"use value for given property");
            Option property = OptionBuilder.create((char)'D');
            options.addOption(oconf);
            options.addOption(property);
            options.addOption(confclass);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return options;
        }
    }

    protected Configuration createConfiguration() {
        return new Configuration();
    }

    protected List<String> getConfigurationsToCreate() {
        return this.confClassnames;
    }

    @VisibleForTesting
    public int loadConfigurationClasses() {
        List<String> toCreate = this.getConfigurationsToCreate();
        int loaded = 0;
        for (String classname : toCreate) {
            try {
                Class<?> loadClass = this.getClassLoader().loadClass(classname);
                Object instance = loadClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                if (!(instance instanceof Configuration)) {
                    throw new ExitUtil.ExitException(56, "Could not create " + classname + " because it is not a Configuration class/subclass");
                }
                ++loaded;
            }
            catch (ClassNotFoundException e) {
                LOG.debug("Failed to load {} because it is not on the classpath", (Object)classname);
            }
            catch (ExitUtil.ExitException e) {
                throw e;
            }
            catch (Exception e) {
                LOG.info("Failed to create {}", (Object)classname, (Object)e);
            }
        }
        return loaded;
    }

    @VisibleForTesting
    public ExitUtil.ExitException launchService(Configuration conf, List<String> processedArgs, boolean addShutdownHook, boolean execute) {
        ExitUtil.ExitException exitException;
        try {
            Throwable failure;
            int exitCode = this.coreServiceLaunch(conf, processedArgs, addShutdownHook, execute);
            if (this.service != null && (failure = this.service.getFailureCause()) != null) {
                Service.STATE failureState = this.service.getFailureState();
                if (failureState == Service.STATE.STOPPED) {
                    LOG.debug("Failure during shutdown: {} ", (Object)failure, (Object)failure);
                } else {
                    throw failure;
                }
            }
            String name = this.getServiceName();
            exitException = exitCode == 0 ? new ServiceLaunchException(exitCode, "%s succeeded", name) : new ServiceLaunchException(exitCode, "%s failed ", name);
        }
        catch (ExitUtil.ExitException ee) {
            exitException = ee;
        }
        catch (Throwable thrown) {
            exitException = ServiceLauncher.convertToExitException(thrown);
        }
        this.noteException(exitException);
        return exitException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int coreServiceLaunch(Configuration conf, List<String> processedArgs, boolean addShutdownHook, boolean execute) throws Exception {
        int exitCode;
        block13: {
            this.instantiateService(conf);
            ServiceShutdownHook shutdownHook = null;
            if (addShutdownHook) {
                shutdownHook = new ServiceShutdownHook((Service)this.service);
                shutdownHook.register(30);
            }
            String name = this.getServiceName();
            LOG.debug("Launched service {}", (Object)name);
            LaunchableService launchableService = null;
            if (this.service instanceof LaunchableService) {
                Configuration newconf;
                LOG.debug("Service {} implements LaunchableService", (Object)name);
                launchableService = (LaunchableService)this.service;
                if (launchableService.isInState(Service.STATE.INITED)) {
                    LOG.warn("LaunchableService {} initialized in constructor before CLI arguments passed in", (Object)name);
                }
                if ((newconf = launchableService.bindArgs(this.configuration, processedArgs)) != null) {
                    this.configuration = newconf;
                }
            }
            if (!this.service.isInState(Service.STATE.INITED)) {
                this.service.init(this.configuration);
            }
            try {
                this.service.start();
                exitCode = 0;
                if (!execute || !this.service.isInState(Service.STATE.STARTED)) break block13;
                if (launchableService != null) {
                    try {
                        exitCode = launchableService.execute();
                        LOG.debug("Service {} execution returned exit code {}", (Object)name, (Object)exitCode);
                        break block13;
                    }
                    finally {
                        this.service.stop();
                    }
                }
                LOG.debug("waiting for service threads to terminate");
                this.service.waitForServiceToStop(0L);
            }
            finally {
                if (shutdownHook != null) {
                    shutdownHook.unregister();
                }
            }
        }
        return exitCode;
    }

    public Service instantiateService(Configuration conf) {
        Object instance;
        Preconditions.checkArgument((conf != null ? 1 : 0) != 0, (Object)"null conf");
        Preconditions.checkArgument((this.serviceClassName != null ? 1 : 0) != 0, (Object)"null service classname");
        Preconditions.checkArgument((!this.serviceClassName.isEmpty() ? 1 : 0) != 0, (Object)"undefined service classname");
        this.configuration = conf;
        try {
            Class<?> serviceClass = this.getClassLoader().loadClass(this.serviceClassName);
            try {
                instance = serviceClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (NoSuchMethodException noEmptyConstructor) {
                LOG.debug("No empty constructor {}", (Object)noEmptyConstructor, (Object)noEmptyConstructor);
                instance = serviceClass.getConstructor(String.class).newInstance(this.serviceClassName);
            }
        }
        catch (Exception e) {
            throw this.serviceCreationFailure(e);
        }
        if (!(instance instanceof Service)) {
            throw new ServiceLaunchException(56, "Not a service class: \"%s\"", this.serviceClassName);
        }
        this.service = (Service)instance;
        return this.service;
    }

    protected static ExitUtil.ExitException convertToExitException(Throwable thrown) {
        int exitCode;
        String message = thrown.toString();
        if (thrown instanceof ExitCodeProvider) {
            exitCode = ((ExitCodeProvider)((Object)thrown)).getExitCode();
            message = thrown.getMessage();
            if (message == null) {
                message = thrown.toString();
            }
        } else {
            exitCode = 50;
        }
        ServiceLaunchException exitException = new ServiceLaunchException(exitCode, message);
        exitException.initCause(thrown);
        return exitException;
    }

    protected ServiceLaunchException serviceCreationFailure(Exception exception) {
        return new ServiceLaunchException(56, (Throwable)exception);
    }

    protected void registerFailureHandling() {
        try {
            this.interruptEscalator = new InterruptEscalator(this, 30000);
            this.interruptEscalator.register("INT");
            this.interruptEscalator.register("TERM");
        }
        catch (IllegalArgumentException e) {
            LOG.warn("{}", (Object)e, (Object)e);
        }
        Thread.setDefaultUncaughtExceptionHandler(new HadoopUncaughtExceptionHandler(this));
    }

    @Override
    public void uncaughtException(Thread thread, Throwable exception) {
        LOG.error("Uncaught exception in thread {} -exiting", (Object)thread, (Object)exception);
        this.exit(ServiceLauncher.convertToExitException(exception));
    }

    public String getServiceName() {
        S s = this.service;
        String name = null;
        if (s != null) {
            try {
                name = s.getName();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (name != null) {
            return "service " + name;
        }
        return "service " + this.serviceName;
    }

    protected void warn(String text) {
        if (LOG.isWarnEnabled()) {
            LOG.warn(text);
        } else {
            System.err.println(text);
        }
    }

    protected void error(String message, Throwable thrown) {
        String text = "Exception: " + message;
        if (LOG.isErrorEnabled()) {
            LOG.error(text, thrown);
        } else {
            System.err.println(text);
            if (thrown != null) {
                System.err.println(thrown.toString());
            }
        }
    }

    protected void exit(int exitCode, String message) {
        ExitUtil.terminate(exitCode, message);
    }

    protected void exit(ExitUtil.ExitException ee) {
        ExitUtil.terminate(ee);
    }

    protected ClassLoader getClassLoader() {
        return this.getClass().getClassLoader();
    }

    public List<String> extractCommandOptions(Configuration conf, List<String> args) {
        int size = args.size();
        if (size <= 1) {
            return new ArrayList<String>(0);
        }
        List<String> coreArgs = args.subList(1, size);
        return this.parseCommandArgs(conf, coreArgs);
    }

    protected List<String> parseCommandArgs(Configuration conf, List<String> args) {
        Preconditions.checkNotNull((Object)this.commandOptions, (Object)"Command options have not been created");
        StringBuilder argString = new StringBuilder(args.size() * 32);
        for (String arg : args) {
            argString.append("\"").append(arg).append("\" ");
        }
        LOG.debug("Command line: {}", (Object)argString);
        try {
            String[] argArray = args.toArray(new String[args.size()]);
            GenericOptionsParser parser = this.createGenericOptionsParser(conf, argArray);
            if (!parser.isParseSuccessful()) {
                throw new ServiceLaunchException(40, "Failed to parse:  %s", argString);
            }
            CommandLine line = parser.getCommandLine();
            List<String> remainingArgs = Arrays.asList(parser.getRemainingArgs());
            LOG.debug("Remaining arguments {}", remainingArgs);
            if (line.hasOption("conf")) {
                String[] filenames = line.getOptionValues("conf");
                this.verifyConfigurationFilesExist(filenames);
                for (String filename : filenames) {
                    File file = new File(filename);
                    LOG.debug("Configuration files {}", (Object)file);
                    this.confResourceUrls.add(file.toURI().toURL());
                }
            }
            if (line.hasOption("hadoopconf")) {
                List<String> classnameList = Arrays.asList(line.getOptionValues("hadoopconf"));
                LOG.debug("Configuration classes {}", classnameList);
                this.confClassnames.addAll(classnameList);
            }
            return remainingArgs;
        }
        catch (IOException e) {
            throw new ServiceLaunchException(40, (Throwable)e);
        }
        catch (RuntimeException e) {
            throw new ServiceLaunchException(40, "Failed to parse:  %s : %s", argString, e);
        }
    }

    protected GenericOptionsParser createGenericOptionsParser(Configuration conf, String[] argArray) throws IOException {
        return new MinimalGenericOptionsParser(conf, this.commandOptions, argArray);
    }

    protected void verifyConfigurationFilesExist(String[] filenames) {
        if (filenames == null) {
            return;
        }
        for (String filename : filenames) {
            File file = new File(filename);
            LOG.debug("Conf file {}", (Object)file.getAbsolutePath());
            if (file.exists()) continue;
            throw new ServiceLaunchException(44, "--conf: configuration file not found: %s", file.getAbsolutePath());
        }
    }

    protected static String startupShutdownMessage(String classname, List<String> args) {
        String hostname = NetUtils.getHostname();
        return StringUtils.createStartupShutdownMessage(classname, hostname, args.toArray(new String[args.size()]));
    }

    protected static void exitWithMessage(int status, String message) {
        ExitUtil.terminate(new ServiceLaunchException(status, message));
    }

    protected static void exitWithUsageMessage() {
        ServiceLauncher.exitWithMessage(42, USAGE_MESSAGE);
    }

    public static void main(String[] args) {
        ServiceLauncher.serviceMain(Arrays.asList(args));
    }

    public static void serviceMain(String ... args) {
        ServiceLauncher.serviceMain(Arrays.asList(args));
    }

    public static void serviceMain(List<String> argsList) {
        if (argsList.isEmpty()) {
            ServiceLauncher.exitWithUsageMessage();
        } else {
            ServiceLauncher serviceLauncher = new ServiceLauncher(argsList.get(0));
            serviceLauncher.launchServiceAndExit(argsList);
        }
    }

    protected static class MinimalGenericOptionsParser
    extends GenericOptionsParser {
        public MinimalGenericOptionsParser(Configuration conf, Options options, String[] args) throws IOException {
            super(conf, options, args);
        }

        @Override
        protected Options buildGeneralOptions(Options opts) {
            return opts;
        }
    }
}

