/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.hadoop.yarn.api.records;

import shaded.org.apache.hadoop.classification.InterfaceAudience;
import shaded.org.apache.hadoop.classification.InterfaceStability;
import shaded.org.apache.hadoop.yarn.util.Records;

@InterfaceAudience.Public
@InterfaceStability.Stable
public abstract class NodeId
implements Comparable<NodeId> {
    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public static NodeId newInstance(String host, int port) {
        NodeId nodeId = Records.newRecord(NodeId.class);
        nodeId.setHost(host);
        nodeId.setPort(port);
        nodeId.build();
        return nodeId;
    }

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract String getHost();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    protected abstract void setHost(String var1);

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract int getPort();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    protected abstract void setPort(int var1);

    public String toString() {
        return this.getHost() + ":" + this.getPort();
    }

    public int hashCode() {
        int prime = 493217;
        int result = 8501;
        result = 493217 * result + this.getHost().hashCode();
        result = 493217 * result + this.getPort();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NodeId other = (NodeId)obj;
        if (!this.getHost().equals(other.getHost())) {
            return false;
        }
        return this.getPort() == other.getPort();
    }

    @Override
    public int compareTo(NodeId other) {
        int hostCompare = this.getHost().compareTo(other.getHost());
        if (hostCompare == 0) {
            if (this.getPort() > other.getPort()) {
                return 1;
            }
            if (this.getPort() < other.getPort()) {
                return -1;
            }
            return 0;
        }
        return hostCompare;
    }

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public static NodeId fromString(String nodeIdStr) {
        String[] parts = nodeIdStr.split(":");
        if (parts.length != 2) {
            throw new IllegalArgumentException("Invalid NodeId [" + nodeIdStr + "]. Expected host:port");
        }
        try {
            NodeId nodeId = NodeId.newInstance(parts[0].trim(), Integer.parseInt(parts[1]));
            return nodeId;
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid port: " + parts[1], e);
        }
    }

    protected abstract void build();
}

