/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.hadoop.yarn.api.records;

import java.util.Set;
import shaded.org.apache.hadoop.classification.InterfaceAudience;
import shaded.org.apache.hadoop.classification.InterfaceStability;
import shaded.org.apache.hadoop.yarn.api.records.NodeId;
import shaded.org.apache.hadoop.yarn.api.records.NodeState;
import shaded.org.apache.hadoop.yarn.api.records.Resource;
import shaded.org.apache.hadoop.yarn.api.records.ResourceUtilization;
import shaded.org.apache.hadoop.yarn.util.Records;

@InterfaceAudience.Public
@InterfaceStability.Stable
public abstract class NodeReport {
    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public static NodeReport newInstance(NodeId nodeId, NodeState nodeState, String httpAddress, String rackName, Resource used, Resource capability, int numContainers, String healthReport, long lastHealthReportTime) {
        return NodeReport.newInstance(nodeId, nodeState, httpAddress, rackName, used, capability, numContainers, healthReport, lastHealthReportTime, null);
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public static NodeReport newInstance(NodeId nodeId, NodeState nodeState, String httpAddress, String rackName, Resource used, Resource capability, int numContainers, String healthReport, long lastHealthReportTime, Set<String> nodeLabels) {
        NodeReport nodeReport = Records.newRecord(NodeReport.class);
        nodeReport.setNodeId(nodeId);
        nodeReport.setNodeState(nodeState);
        nodeReport.setHttpAddress(httpAddress);
        nodeReport.setRackName(rackName);
        nodeReport.setUsed(used);
        nodeReport.setCapability(capability);
        nodeReport.setNumContainers(numContainers);
        nodeReport.setHealthReport(healthReport);
        nodeReport.setLastHealthReportTime(lastHealthReportTime);
        nodeReport.setNodeLabels(nodeLabels);
        return nodeReport;
    }

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract NodeId getNodeId();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public abstract void setNodeId(NodeId var1);

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract NodeState getNodeState();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public abstract void setNodeState(NodeState var1);

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract String getHttpAddress();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public abstract void setHttpAddress(String var1);

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract String getRackName();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public abstract void setRackName(String var1);

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract Resource getUsed();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public abstract void setUsed(Resource var1);

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract Resource getCapability();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public abstract void setCapability(Resource var1);

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public abstract int getNumContainers();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public abstract void setNumContainers(int var1);

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract String getHealthReport();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public abstract void setHealthReport(String var1);

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract long getLastHealthReportTime();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public abstract void setLastHealthReportTime(long var1);

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract Set<String> getNodeLabels();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public abstract void setNodeLabels(Set<String> var1);

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public ResourceUtilization getAggregatedContainersUtilization() {
        throw new UnsupportedOperationException("subclass must implement this method");
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public void setAggregatedContainersUtilization(ResourceUtilization containersUtilization) {
        throw new UnsupportedOperationException("subclass must implement this method");
    }

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract ResourceUtilization getNodeUtilization();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public abstract void setNodeUtilization(ResourceUtilization var1);
}

