/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.hadoop.yarn.api.records;

import java.io.Serializable;
import java.util.Comparator;
import shaded.org.apache.hadoop.classification.InterfaceAudience;
import shaded.org.apache.hadoop.classification.InterfaceStability;
import shaded.org.apache.hadoop.yarn.api.records.Resource;
import shaded.org.apache.hadoop.yarn.util.Records;

@InterfaceAudience.Public
@InterfaceStability.Unstable
public abstract class ReservationRequest
implements Comparable<ReservationRequest> {
    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public static ReservationRequest newInstance(Resource capability, int numContainers) {
        return ReservationRequest.newInstance(capability, numContainers, 1, -1L);
    }

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public static ReservationRequest newInstance(Resource capability, int numContainers, int concurrency, long duration) {
        ReservationRequest request = Records.newRecord(ReservationRequest.class);
        request.setCapability(capability);
        request.setNumContainers(numContainers);
        request.setConcurrency(concurrency);
        request.setDuration(duration);
        return request;
    }

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public abstract Resource getCapability();

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public abstract void setCapability(Resource var1);

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public abstract int getNumContainers();

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public abstract void setNumContainers(int var1);

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public abstract int getConcurrency();

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public abstract void setConcurrency(int var1);

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public abstract long getDuration();

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public abstract void setDuration(long var1);

    public int hashCode() {
        int prime = 2153;
        int result = 2459;
        Resource capability = this.getCapability();
        result = 2153 * result + (capability == null ? 0 : capability.hashCode());
        result = 2153 * result + this.getNumContainers();
        result = 2153 * result + this.getConcurrency();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ReservationRequest other = (ReservationRequest)obj;
        Resource capability = this.getCapability();
        if (capability == null ? other.getCapability() != null : !capability.equals(other.getCapability())) {
            return false;
        }
        if (this.getNumContainers() != other.getNumContainers()) {
            return false;
        }
        return this.getConcurrency() == other.getConcurrency();
    }

    @Override
    public int compareTo(ReservationRequest other) {
        int numContainersComparison = this.getNumContainers() - other.getNumContainers();
        if (numContainersComparison == 0) {
            int concurrencyComparison = this.getConcurrency() - other.getConcurrency();
            if (concurrencyComparison == 0) {
                return this.getCapability().compareTo(other.getCapability());
            }
            return concurrencyComparison;
        }
        return numContainersComparison;
    }

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public static class ReservationRequestComparator
    implements Comparator<ReservationRequest>,
    Serializable {
        private static final long serialVersionUID = 1L;

        @Override
        public int compare(ReservationRequest r1, ReservationRequest r2) {
            int ret = r1.getNumContainers() - r2.getNumContainers();
            if (ret == 0) {
                ret = r1.getConcurrency() - r2.getConcurrency();
            }
            if (ret == 0) {
                ret = r1.getCapability().compareTo(r2.getCapability());
            }
            return ret;
        }
    }
}

