/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.hadoop.yarn.api.records;

import shaded.org.apache.hadoop.classification.InterfaceAudience;
import shaded.org.apache.hadoop.classification.InterfaceStability;
import shaded.org.apache.hadoop.yarn.api.protocolrecords.ResourceTypes;
import shaded.org.apache.hadoop.yarn.util.Records;

public abstract class ResourceTypeInfo
implements Comparable<ResourceTypeInfo> {
    public abstract String getName();

    public abstract void setName(String var1);

    public abstract String getDefaultUnit();

    public abstract void setDefaultUnit(String var1);

    public abstract ResourceTypes getResourceType();

    public abstract void setResourceType(ResourceTypes var1);

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public static ResourceTypeInfo newInstance(ResourceTypeInfo other) {
        ResourceTypeInfo resourceType = Records.newRecord(ResourceTypeInfo.class);
        ResourceTypeInfo.copy(other, resourceType);
        return resourceType;
    }

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public static ResourceTypeInfo newInstance(String name, String units, ResourceTypes type) {
        ResourceTypeInfo resourceType = Records.newRecord(ResourceTypeInfo.class);
        resourceType.setName(name);
        resourceType.setResourceType(type);
        resourceType.setDefaultUnit(units);
        return resourceType;
    }

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public static ResourceTypeInfo newInstance(String name, String units) {
        return ResourceTypeInfo.newInstance(name, units, ResourceTypes.COUNTABLE);
    }

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public static ResourceTypeInfo newInstance(String name) {
        return ResourceTypeInfo.newInstance(name, "");
    }

    public static void copy(ResourceTypeInfo src, ResourceTypeInfo dst) {
        dst.setName(src.getName());
        dst.setResourceType(src.getResourceType());
        dst.setDefaultUnit(src.getDefaultUnit());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("<name=").append(this.getName()).append(" default-unit=").append(this.getDefaultUnit()).append(" type=" + (Object)((Object)this.getResourceType())).append(">");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceTypeInfo)) {
            return false;
        }
        ResourceTypeInfo r = (ResourceTypeInfo)obj;
        return this.getName().equals(r.getName()) && this.getResourceType().equals((Object)r.getResourceType()) && this.getDefaultUnit().equals(r.getDefaultUnit());
    }

    public int hashCode() {
        int prime = 47;
        int result = 47 + this.getName().hashCode();
        result = 47 * result + this.getResourceType().hashCode();
        return result;
    }

    @Override
    public int compareTo(ResourceTypeInfo other) {
        int diff = this.getName().compareTo(other.getName());
        if (diff == 0 && (diff = this.getDefaultUnit().compareTo(other.getDefaultUnit())) == 0) {
            diff = this.getResourceType().compareTo(other.getResourceType());
        }
        return diff;
    }
}

