/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.hadoop.yarn.api.records;

import shaded.org.apache.hadoop.classification.InterfaceAudience;
import shaded.org.apache.hadoop.classification.InterfaceStability;
import shaded.org.apache.hadoop.yarn.api.records.UpdateContainerRequest;
import shaded.org.apache.hadoop.yarn.util.Records;

@InterfaceAudience.Public
@InterfaceStability.Unstable
public abstract class UpdateContainerError {
    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public static UpdateContainerError newInstance(String reason, UpdateContainerRequest updateContainerRequest) {
        UpdateContainerError error = Records.newRecord(UpdateContainerError.class);
        error.setReason(reason);
        error.setUpdateContainerRequest(updateContainerRequest);
        return error;
    }

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public abstract String getReason();

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public abstract void setReason(String var1);

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public abstract int getCurrentContainerVersion();

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public abstract void setCurrentContainerVersion(int var1);

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public abstract UpdateContainerRequest getUpdateContainerRequest();

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public abstract void setUpdateContainerRequest(UpdateContainerRequest var1);

    public int hashCode() {
        int prime = 2153;
        int result = 2459;
        String reason = this.getReason();
        UpdateContainerRequest updateReq = this.getUpdateContainerRequest();
        result = 2153 * result + (reason == null ? 0 : reason.hashCode());
        result = 2153 * result + (updateReq == null ? 0 : updateReq.hashCode());
        return result;
    }

    public String toString() {
        return "UpdateContainerError{reason=" + this.getReason() + ", " + "currentVersion=" + this.getCurrentContainerVersion() + ", " + "req=" + this.getUpdateContainerRequest() + "}";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UpdateContainerError other = (UpdateContainerError)obj;
        String reason = this.getReason();
        if (reason == null ? other.getReason() != null : !reason.equals(other.getReason())) {
            return false;
        }
        UpdateContainerRequest req = this.getUpdateContainerRequest();
        if (req == null ? other.getUpdateContainerRequest() != null : !req.equals(other.getUpdateContainerRequest())) {
            return false;
        }
        return this.getCurrentContainerVersion() == other.getCurrentContainerVersion();
    }
}

