/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.hadoop.yarn.api.records.timelineservice;

import shaded.org.apache.hadoop.classification.InterfaceAudience;
import shaded.org.apache.hadoop.classification.InterfaceStability;
import shaded.org.apache.hadoop.yarn.api.records.timelineservice.HierarchicalTimelineEntity;
import shaded.org.apache.hadoop.yarn.api.records.timelineservice.TimelineEntity;
import shaded.org.apache.hadoop.yarn.api.records.timelineservice.TimelineEntityType;
import shaded.org.apache.hadoop.yarn.api.records.timelineservice.TimelineEvent;

@InterfaceAudience.Public
@InterfaceStability.Unstable
public class ApplicationEntity
extends HierarchicalTimelineEntity {
    public static final String QUEUE_INFO_KEY = "SYSTEM_INFO_QUEUE";

    public ApplicationEntity() {
        super(TimelineEntityType.YARN_APPLICATION.toString());
    }

    public ApplicationEntity(TimelineEntity entity) {
        super(entity);
        if (!entity.getType().equals(TimelineEntityType.YARN_APPLICATION.toString())) {
            throw new IllegalArgumentException("Incompatible entity type: " + this.getId());
        }
    }

    public String getQueue() {
        return this.getInfo().get(QUEUE_INFO_KEY).toString();
    }

    public void setQueue(String queue) {
        this.addInfo(QUEUE_INFO_KEY, queue);
    }

    public static boolean isApplicationEntity(TimelineEntity te) {
        return te == null ? false : te.getType().equals(TimelineEntityType.YARN_APPLICATION.toString());
    }

    public static TimelineEvent getApplicationEvent(TimelineEntity te, String eventId) {
        if (ApplicationEntity.isApplicationEntity(te)) {
            for (TimelineEvent event : te.getEvents()) {
                if (!event.getId().equals(eventId)) continue;
                return event;
            }
        }
        return null;
    }
}

