/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.hadoop.yarn.api.records.timelineservice;

import java.util.Collection;
import java.util.Date;
import java.util.NavigableSet;
import java.util.TreeSet;
import javax.xml.bind.annotation.XmlElement;
import shaded.org.apache.hadoop.classification.InterfaceAudience;
import shaded.org.apache.hadoop.classification.InterfaceStability;
import shaded.org.apache.hadoop.yarn.api.records.timelineservice.FlowRunEntity;
import shaded.org.apache.hadoop.yarn.api.records.timelineservice.TimelineEntity;
import shaded.org.apache.hadoop.yarn.api.records.timelineservice.TimelineEntityType;

@InterfaceAudience.Public
@InterfaceStability.Unstable
public class FlowActivityEntity
extends TimelineEntity {
    public static final String CLUSTER_INFO_KEY = "SYSTEM_INFO_CLUSTER";
    public static final String DATE_INFO_KEY = "SYSTEM_INFO_DATE";
    public static final String USER_INFO_KEY = "SYSTEM_INFO_USER";
    public static final String FLOW_NAME_INFO_KEY = "SYSTEM_INFO_FLOW_NAME";
    private final NavigableSet<FlowRunEntity> flowRuns = new TreeSet<FlowRunEntity>();

    public FlowActivityEntity() {
        super(TimelineEntityType.YARN_FLOW_ACTIVITY.toString());
        this.setConfigs(null);
    }

    public FlowActivityEntity(String cluster, long time, String user, String flowName) {
        this();
        this.setCluster(cluster);
        this.setDate(time);
        this.setUser(user);
        this.setFlowName(flowName);
    }

    public FlowActivityEntity(TimelineEntity entity) {
        super(entity);
        if (!TimelineEntityType.YARN_FLOW_ACTIVITY.matches(entity.getType())) {
            throw new IllegalArgumentException("Incompatible entity type: " + this.getId());
        }
        this.setConfigs(null);
    }

    @Override
    @XmlElement(name="id")
    public String getId() {
        String id = super.getId();
        if (id == null) {
            StringBuilder sb = new StringBuilder();
            sb.append(this.getCluster());
            sb.append('/');
            sb.append(this.getDate().getTime());
            sb.append('/');
            sb.append(this.getUser());
            sb.append('@');
            sb.append(this.getFlowName());
            id = sb.toString();
            this.setId(id);
        }
        return id;
    }

    @Override
    public int compareTo(TimelineEntity entity) {
        int comparison = this.getType().compareTo(entity.getType());
        if (comparison == 0) {
            FlowActivityEntity other = (FlowActivityEntity)entity;
            int clusterComparison = this.getCluster().compareTo(other.getCluster());
            if (clusterComparison != 0) {
                return clusterComparison;
            }
            int dateComparisonDescending = (int)(other.getDate().getTime() - this.getDate().getTime());
            if (dateComparisonDescending != 0) {
                return dateComparisonDescending;
            }
            int userComparison = this.getUser().compareTo(other.getUser());
            if (userComparison != 0) {
                return userComparison;
            }
            return this.getFlowName().compareTo(other.getFlowName());
        }
        return comparison;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    public String getCluster() {
        return (String)this.getInfo().get(CLUSTER_INFO_KEY);
    }

    public void setCluster(String cluster) {
        this.addInfo(CLUSTER_INFO_KEY, cluster);
    }

    public Date getDate() {
        Object date = this.getInfo().get(DATE_INFO_KEY);
        if (date != null) {
            if (date instanceof Long) {
                return new Date((Long)date);
            }
            if (date instanceof Date) {
                return (Date)date;
            }
        }
        return null;
    }

    public void setDate(long time) {
        Date date = new Date(time);
        this.addInfo(DATE_INFO_KEY, date);
    }

    public String getUser() {
        return (String)this.getInfo().get(USER_INFO_KEY);
    }

    public void setUser(String user) {
        this.addInfo(USER_INFO_KEY, user);
    }

    public String getFlowName() {
        return (String)this.getInfo().get(FLOW_NAME_INFO_KEY);
    }

    public void setFlowName(String flowName) {
        this.addInfo(FLOW_NAME_INFO_KEY, flowName);
    }

    public void addFlowRun(FlowRunEntity run) {
        this.flowRuns.add(run);
    }

    public void addFlowRuns(Collection<FlowRunEntity> runs) {
        this.flowRuns.addAll(runs);
    }

    @XmlElement(name="flowruns")
    public NavigableSet<FlowRunEntity> getFlowRuns() {
        return this.flowRuns;
    }

    public int getNumberOfRuns() {
        return this.flowRuns.size();
    }
}

