/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.hadoop.yarn.api.records.timelineservice;

import java.util.Map;
import shaded.org.apache.hadoop.yarn.api.records.timelineservice.TimelineMetric;
import shaded.org.apache.hadoop.yarn.api.records.timelineservice.TimelineMetricCalculator;

public enum TimelineMetricOperation {
    NOP("NOP"){

        @Override
        public TimelineMetric exec(TimelineMetric incoming, TimelineMetric base, Map<Object, Object> state) {
            return base;
        }
    }
    ,
    MAX("MAX"){

        @Override
        public TimelineMetric exec(TimelineMetric incoming, TimelineMetric base, Map<Object, Object> state) {
            if (base == null) {
                return incoming;
            }
            Number incomingValue = incoming.getSingleDataValue();
            Number aggregateValue = base.getSingleDataValue();
            if (aggregateValue == null) {
                aggregateValue = Long.MIN_VALUE;
            }
            if (TimelineMetricCalculator.compare(incomingValue, aggregateValue) > 0) {
                base.addValue(incoming.getSingleDataTimestamp(), incomingValue);
            }
            return base;
        }
    }
    ,
    REPLACE("REPLACE"){

        @Override
        public TimelineMetric exec(TimelineMetric incoming, TimelineMetric base, Map<Object, Object> state) {
            return incoming;
        }
    }
    ,
    SUM("SUM"){

        @Override
        public TimelineMetric exec(TimelineMetric incoming, TimelineMetric base, Map<Object, Object> state) {
            Object prevMetric;
            if (base == null) {
                return incoming;
            }
            Number incomingValue = incoming.getSingleDataValue();
            Number aggregateValue = base.getSingleDataValue();
            Number result = TimelineMetricCalculator.sum(incomingValue, aggregateValue);
            if (state != null && (prevMetric = state.get(TimelineMetricOperation.PREV_METRIC_STATE_KEY)) instanceof TimelineMetric) {
                result = TimelineMetricCalculator.sub(result, ((TimelineMetric)prevMetric).getSingleDataValue());
            }
            base.addValue(incoming.getSingleDataTimestamp(), result);
            return base;
        }
    }
    ,
    AVG("AVERAGE"){

        @Override
        public TimelineMetric exec(TimelineMetric incoming, TimelineMetric base, Map<Object, Object> state) {
            throw new UnsupportedOperationException("Unsupported aggregation operation: AVERAGE");
        }
    };

    public static final String PREV_METRIC_STATE_KEY = "PREV_METRIC";
    private final String opName;

    public TimelineMetric aggregate(TimelineMetric incoming, TimelineMetric aggregate, Map<Object, Object> state) {
        return this.exec(incoming, aggregate, state);
    }

    private TimelineMetricOperation(String opString) {
        this.opName = opString;
    }

    public String toString() {
        return this.opName;
    }

    abstract TimelineMetric exec(TimelineMetric var1, TimelineMetric var2, Map<Object, Object> var3);
}

